/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.AudienceProvider;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.MinecraftHelp;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.messages.CarbonMessageSource;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.help.result.CommandEntry;
import org.incendo.cloud.help.result.IndexCommandResult;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.Suggestion;

@DefaultQualifier(value=NonNull.class)
public final class HelpCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final MinecraftHelp<Commander> minecraftHelp;

    @Inject
    public HelpCommand(CommandManager<Commander> commandManager, CarbonMessageSource messageSource, CarbonMessages carbonMessages) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.minecraftHelp = HelpCommand.createHelp(commandManager, messageSource);
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("carbon", new String[0]);
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"help");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).literal("help", new String[0]).optional("query", StringParser.greedyStringParser(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandHelpArgumentQuery()), this::suggestQueries).permission("carbon.help").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandHelpDescription())).handler(this::execute).build();
        this.commandManager.command(command);
    }

    private void execute(CommandContext<Commander> ctx) {
        this.minecraftHelp.queryCommands((String)ctx.getOrDefault("query", (Object)""), (Commander)ctx.sender());
    }

    private CompletableFuture<Iterable<Suggestion>> suggestQueries(CommandContext<Commander> ctx, CommandInput input) {
        IndexCommandResult result = this.commandManager.createHelpHandler().queryRootIndex((Object)((Commander)ctx.sender()));
        return CompletableFuture.completedFuture(result.entries().stream().map(CommandEntry::syntax).map(Suggestion::suggestion).toList());
    }

    private static MinecraftHelp<Commander> createHelp(CommandManager<Commander> manager, CarbonMessageSource messageSource) {
        return MinecraftHelp.builder().commandManager(manager).audienceProvider(AudienceProvider.nativeAudience()).commandPrefix("/carbon help").colors(MinecraftHelp.helpColors(TextColor.color((int)14719487), (TextColor)NamedTextColor.WHITE, TextColor.color((int)14490564), (TextColor)NamedTextColor.GRAY, (TextColor)NamedTextColor.DARK_GRAY)).messageProvider((sender, key, args) -> {
            String messageKey = "command.help.misc." + key;
            TagResolver.Builder tagResolver = TagResolver.builder();
            for (Map.Entry entry : args.entrySet()) {
                String k = (String)entry.getKey();
                tagResolver.resolver((TagResolver)Placeholder.parsed((String)k, (String)((String)entry.getValue())));
            }
            return MiniMessage.miniMessage().deserialize(messageSource.messageOf((Audience)sender, messageKey), tagResolver.build());
        }).build();
    }
}

