/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.util.Pagination;
import net.draycia.carbon.common.util.PaginationHelper;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.standard.IntegerParser;

@DefaultQualifier(value=NonNull.class)
public final class IgnoreListCommand
extends CarbonCommand {
    private final UserManager<?> users;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages messages;
    private final PaginationHelper pagination;

    @Inject
    public IgnoreListCommand(UserManager<?> userManager, CommandManager<Commander> commandManager, CarbonMessages messages, PaginationHelper pagination) {
        this.users = userManager;
        this.commandManager = commandManager;
        this.messages = messages;
        this.pagination = pagination;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("ignorelist", "listignores");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"ignorelist");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).permission("carbon.ignore").senderType(PlayerCommander.class).optional("page", IntegerParser.integerParser((int)1), DefaultValue.constant((Object)1)).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.commandIgnoreListDescription())).handler(this::execute).build();
        this.commandManager.command(command);
    }

    private void execute(CommandContext<PlayerCommander> ctx) {
        CarbonPlayer sender = ((PlayerCommander)ctx.sender()).carbonPlayer();
        List<Supplier> elements = sender.ignoring().stream().sorted().map(id -> () -> (CarbonPlayer)this.users.user((UUID)id).join()).toList();
        if (elements.isEmpty()) {
            this.messages.commandIgnoreListNoneIgnored(sender);
            return;
        }
        Pagination<Supplier> pagination = Pagination.builder().header(this.messages::commandIgnoreListPaginationHeader).item((e, lastOfPage) -> {
            CarbonPlayer p = (CarbonPlayer)e.get();
            return this.messages.commandIgnoreListPaginationElement(p.displayName(), p.username());
        }).footer(this.pagination.footerRenderer(p -> "/" + this.commandSettings().name() + " " + p)).pageOutOfRange(this.messages::paginationOutOfRange).build();
        int page = (Integer)ctx.get("page");
        pagination.render(elements, page, 6).forEach(arg_0 -> ((CarbonPlayer)sender).sendMessage(arg_0));
    }
}

