/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.Objects;
import net.draycia.carbon.api.channels.ChannelPermissionResult;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.channels.CarbonChannelRegistry;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;

@DefaultQualifier(value=NonNull.class)
public final class JoinCommand
extends CarbonCommand {
    private final CarbonChannelRegistry channelRegistry;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;

    @Inject
    public JoinCommand(CarbonChannelRegistry channelRegistry, CommandManager<Commander> commandManager, CarbonMessages carbonMessages) {
        this.channelRegistry = channelRegistry;
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("join", new String[0]);
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"join");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).required("channel", StringParser.greedyStringParser(), SuggestionProvider.blocking((context, s) -> {
            CarbonPlayer sender = ((PlayerCommander)context.sender()).carbonPlayer();
            return sender.leftChannels().stream().map(this.channelRegistry::channel).filter(Objects::nonNull).filter(channel -> channel.permissions().joinPermitted(sender).permitted() || channel.permissions().hearingPermitted(sender).permitted() || channel.permissions().speechPermitted(sender).permitted()).map(channel -> channel.key().value()).map(Suggestion::suggestion).toList();
        })).permission("carbon.join").senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandJoinDescription())).handler(handler -> {
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            @Nullable ChatChannel channel = this.channelRegistry.channelByValue((String)handler.get("channel"));
            if (channel == null) {
                this.carbonMessages.channelNotFound(sender);
                return;
            }
            ChannelPermissionResult permitted = channel.permissions().joinPermitted(sender);
            if (!permitted.permitted()) {
                sender.sendMessage(permitted.reason());
                return;
            }
            if (!sender.leftChannels().contains(channel.key())) {
                this.carbonMessages.channelNotLeft(sender);
                return;
            }
            sender.joinChannel(channel);
            this.carbonMessages.channelJoined(sender);
        }).build();
        this.commandManager.command(command);
    }
}

