/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.DurationParser;
import org.incendo.cloud.parser.standard.UUIDParser;

@DefaultQualifier(value=NonNull.class)
public final class MuteCommand
extends CarbonCommand {
    private final CarbonServer server;
    private final UserManager<?> users;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final ParserFactory parserFactory;

    @Inject
    public MuteCommand(UserManager<?> userManager, CarbonServer server, CommandManager<Commander> commandManager, CarbonMessages carbonMessages, ParserFactory parserFactory) {
        this.server = server;
        this.users = userManager;
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.parserFactory = parserFactory;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("mute", new String[0]);
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"mute");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).optional("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandMuteArgumentPlayer())).flag(this.commandManager.flagBuilder("uuid").withAliases(new String[]{"u"}).withDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandMuteArgumentUUID())).withComponent(UUIDParser.uuidParser())).flag(this.commandManager.flagBuilder("duration").withAliases(new String[]{"d"}).withDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandMuteArgumentDuration())).withComponent(DurationParser.durationParser())).permission("carbon.mute").senderType(Commander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandMuteDescription())).handler(handler -> {
            PlayerCommander playerCommander;
            CarbonPlayer target;
            Commander sender = (Commander)handler.sender();
            if (handler.contains("player")) {
                target = (CarbonPlayer)handler.get("player");
            } else if (handler.flags().contains("uuid")) {
                target = (CarbonPlayer)this.users.user((UUID)handler.flags().get("uuid")).join();
            } else {
                this.carbonMessages.muteNoTarget(sender);
                return;
            }
            if (target.hasPermission("carbon.mute.exempt")) {
                this.carbonMessages.muteExempt(sender);
                return;
            }
            if (sender instanceof PlayerCommander && (playerCommander = (PlayerCommander)sender).carbonPlayer().equals(target)) {
                this.carbonMessages.muteExempt(playerCommander);
                return;
            }
            if (handler.flags().contains("duration")) {
                this.handleTempMute((Duration)handler.flags().get("duration"), target);
                return;
            }
            this.carbonMessages.muteAlertRecipient(target);
            this.carbonMessages.muteAlertRecipient(this.server.console());
            for (CarbonPlayer carbonPlayer : this.server.players()) {
                if (carbonPlayer.equals(target) || !carbonPlayer.hasPermission("carbon.mute.alert")) continue;
                this.carbonMessages.muteAlertPlayers(carbonPlayer, target.displayName());
            }
            target.muted(true);
        }).build();
        this.commandManager.command(command);
    }

    private void handleTempMute(Duration duration, CarbonPlayer target) {
        @Nullable Component formattedDuration = duration.toDaysPart() > 0L ? this.carbonMessages.durationDays(duration.toDaysPart(), duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart()) : this.carbonMessages.durationHours(duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
        this.carbonMessages.tempMuteAlertRecipient(target, formattedDuration);
        this.carbonMessages.tempMuteAlertRecipient(this.server.console(), formattedDuration);
        for (CarbonPlayer carbonPlayer : this.server.players()) {
            if (carbonPlayer.equals(target) || !carbonPlayer.hasPermission("carbon.mute.alert")) continue;
            this.carbonMessages.tempMuteAlertPlayers(carbonPlayer, target.displayName(), formattedDuration);
        }
        target.muted(true);
        target.muteExpiration(Instant.now().plus(duration).toEpochMilli());
    }
}

