/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.TagPermissions;
import net.draycia.carbon.common.util.CloudUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.StringParser;

@DefaultQualifier(value=NonNull.class)
public final class NicknameCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final ParserFactory parserFactory;
    private final ConfigManager config;

    @Inject
    public NicknameCommand(CommandManager<Commander> commandManager, CarbonMessages carbonMessages, ParserFactory parserFactory, ConfigManager config) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.parserFactory = parserFactory;
        this.config = config;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("nickname", "nick");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"nickname");
    }

    @Override
    public void init() {
        if (!this.config.primaryConfig().nickname().useCarbonNicknames()) {
            return;
        }
        Command.Builder selfRoot = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases());
        Command.Builder othersRoot = selfRoot.literal("player", new String[0]).required("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameArgumentPlayer()));
        this.commandManager.command(selfRoot.permission("carbon.nickname").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameDescription())).handler(ctx -> this.checkOwnNickname(CloudUtils.nonPlayerMustProvidePlayer(this.carbonMessages, (Commander)ctx.sender()))));
        this.commandManager.command(othersRoot.permission("carbon.nickname.others").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameOthersDescription())).handler(ctx -> this.checkOthersNickname((Audience)ctx.sender(), (CarbonPlayer)ctx.get("player"))));
        this.commandManager.command(selfRoot.permission("carbon.nickname.set").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameSetDescription())).required("nickname", StringParser.greedyStringParser(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameArgumentNickname())).handler(ctx -> this.applyNickname((Commander)ctx.sender(), CloudUtils.nonPlayerMustProvidePlayer(this.carbonMessages, (Commander)ctx.sender()), (String)ctx.get("nickname"))));
        this.commandManager.command(othersRoot.permission("carbon.nickname.others.set").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameOthersSetDescription())).required("nickname", StringParser.greedyStringParser(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameArgumentNickname())).handler(ctx -> this.applyNickname((Commander)ctx.sender(), (CarbonPlayer)ctx.get("player"), (String)ctx.get("nickname"))));
        this.commandManager.command(selfRoot.permission("carbon.nickname.set").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameResetDescription())).literal("reset", new String[0]).handler(ctx -> this.resetNickname((Commander)ctx.sender(), CloudUtils.nonPlayerMustProvidePlayer(this.carbonMessages, (Commander)ctx.sender()))));
        this.commandManager.command(othersRoot.permission("carbon.nickname.others.set").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandNicknameOthersResetDescription())).literal("reset", new String[0]).handler(ctx -> this.resetNickname((Commander)ctx.sender(), (CarbonPlayer)ctx.get("player"))));
    }

    private void resetNickname(Commander sender, CarbonPlayer target) {
        PlayerCommander playerCommander;
        target.nickname(null);
        if (sender instanceof PlayerCommander && (playerCommander = (PlayerCommander)sender).carbonPlayer().uuid().equals(target.uuid())) {
            this.carbonMessages.nicknameReset(target);
        } else {
            this.carbonMessages.nicknameResetOthers(sender, target.username());
        }
    }

    private void applyNickname(Commander sender, CarbonPlayer target, String nick) {
        PlayerCommander playerCommander;
        Component parsedNick = NicknameCommand.parseNickname(sender, nick);
        String plainNick = PlainTextComponentSerializer.plainText().serialize(parsedNick);
        int minLength = this.config.primaryConfig().nickname().minLength();
        int maxLength = this.config.primaryConfig().nickname().maxLength();
        if (plainNick.length() < minLength || maxLength < plainNick.length()) {
            this.carbonMessages.nicknameErrorCharacterLimit(sender, parsedNick, minLength, maxLength);
            return;
        }
        if (this.config.primaryConfig().nickname().blackList().stream().anyMatch(plainNick::equalsIgnoreCase)) {
            this.carbonMessages.nicknameErrorBlackList(sender, parsedNick);
            return;
        }
        if (!sender.hasPermission("carbon.nickname.filter") && !plainNick.matches(this.config.primaryConfig().nickname().filter())) {
            this.carbonMessages.nicknameErrorFilter(sender, parsedNick);
            return;
        }
        target.nickname(parsedNick);
        if (sender instanceof PlayerCommander && (playerCommander = (PlayerCommander)sender).carbonPlayer().uuid().equals(target.uuid())) {
            this.carbonMessages.nicknameSet(sender, parsedNick);
        } else {
            this.carbonMessages.nicknameSet(target, parsedNick);
            this.carbonMessages.nicknameSetOthers(sender, target.username(), parsedNick);
        }
    }

    private void checkOwnNickname(CarbonPlayer sender) {
        if (sender.nickname() != null) {
            this.carbonMessages.nicknameShow(sender, sender.username(), sender.nickname());
        } else {
            this.carbonMessages.nicknameShowUnset(sender, sender.username());
        }
    }

    private void checkOthersNickname(Audience sender, CarbonPlayer target) {
        if (target.nickname() != null) {
            this.carbonMessages.nicknameShowOthers(sender, target.username(), target.nickname());
        } else {
            this.carbonMessages.nicknameShowOthersUnset(sender, target.username());
        }
    }

    private static Component parseNickname(Commander sender, String nick) {
        return TagPermissions.parseTags(sender, "carbon.nickname.tags", NicknameCommand.trimQuotes(nick), sender::hasPermission);
    }

    private static String trimQuotes(String string) {
        if (string.length() < 3) {
            return string;
        }
        char first = string.charAt(0);
        if ((first == '\'' || first == '\"') && string.endsWith(String.valueOf(first))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

