/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.github.benmanes.caffeine.cache.Cache;
import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.Option;
import net.draycia.carbon.common.messages.TagPermissions;
import net.draycia.carbon.common.users.NetworkUsers;
import net.draycia.carbon.common.users.PartyInvites;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.util.Pagination;
import net.draycia.carbon.common.util.PaginationHelper;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.incendo.cloud.parser.standard.StringParser;

@DefaultQualifier(value=NonNull.class)
public final class PartyCommands
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final ParserFactory parserFactory;
    private final UserManagerInternal<?> userManager;
    private final PartyInvites partyInvites;
    private final ConfigManager config;
    private final CarbonMessages messages;
    private final PaginationHelper pagination;
    private final NetworkUsers network;

    @Inject
    public PartyCommands(CommandManager<Commander> commandManager, ParserFactory parserFactory, UserManagerInternal<?> userManager, PartyInvites partyInvites, ConfigManager config, CarbonMessages messages, PaginationHelper pagination, NetworkUsers network) {
        this.commandManager = commandManager;
        this.parserFactory = parserFactory;
        this.userManager = userManager;
        this.partyInvites = partyInvites;
        this.config = config;
        this.messages = messages;
        this.pagination = pagination;
        this.network = network;
    }

    @Override
    public void init() {
        if (!this.config.primaryConfig().partyChat().enabled) {
            return;
        }
        Command.Builder root = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).senderType(PlayerCommander.class).permission("carbon.parties");
        Command.Builder info = root.commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyDesc())).handler(this::info);
        this.commandManager.command(info);
        this.commandManager.command(info.literal("page", new String[0]).optional("page", IntegerParser.integerParser((int)1), DefaultValue.constant((Object)1)));
        this.commandManager.command(root.literal("create", new String[0]).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyCreateDesc())).optional("name", StringParser.greedyStringParser()).handler(this::createParty));
        this.commandManager.command(root.literal("invite", new String[0]).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyInviteDesc())).required("player", (ParserDescriptor)this.parserFactory.carbonPlayer()).handler(this::invitePlayer));
        this.commandManager.command(root.literal("accept", new String[0]).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyAcceptDesc())).optional("sender", (ParserDescriptor)this.parserFactory.carbonPlayer()).handler(this::acceptInvite));
        this.commandManager.command(root.literal("leave", new String[0]).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyLeaveDesc())).handler(this::leaveParty));
        this.commandManager.command(root.literal("disband", new String[0]).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.partyDisbandDesc())).handler(this::disbandParty));
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("party", "group");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"party");
    }

    private void info(CommandContext<PlayerCommander> ctx) {
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        @Nullable Party party = player.party().join();
        if (party == null) {
            this.messages.notInParty(player);
            return;
        }
        this.messages.currentParty(player, party.name());
        List<Supplier> elements = party.members().stream().sorted(Comparator.comparing(this.network::online).reversed().thenComparing(UUID::compareTo)).map(id -> () -> (CarbonPlayer)this.userManager.user((UUID)id).join()).toList();
        if (elements.isEmpty()) {
            throw new IllegalStateException();
        }
        Pagination<Supplier> pagination = Pagination.builder().header((page, pages) -> this.messages.commandPartyPaginationHeader(party.name())).item((e, lastOfPage) -> {
            CarbonPlayer p = (CarbonPlayer)e.get();
            return this.messages.commandPartyPaginationElement(p.displayName(), p.username(), new Option(this.network.online(p)));
        }).footer(this.pagination.footerRenderer(p -> "/" + this.commandSettings().name() + " page " + p)).pageOutOfRange(this.messages::paginationOutOfRange).build();
        int page2 = (Integer)ctx.getOrDefault("page", (Object)1);
        pagination.render(elements, page2, 6).forEach(arg_0 -> ((CarbonPlayer)player).sendMessage(arg_0));
    }

    private void createParty(CommandContext<PlayerCommander> ctx) {
        Party party;
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        @Nullable Party oldParty = player.party().join();
        if (oldParty != null) {
            this.messages.mustLeavePartyFirst(player);
            return;
        }
        String name = (String)ctx.getOrDefault("name", (Object)(player.username() + "'s party"));
        Component component = TagPermissions.parseTags(player, "carbon.parties.name.tags", name, player::hasPermission);
        try {
            party = this.userManager.createParty(component);
        }
        catch (IllegalArgumentException e) {
            this.messages.partyNameTooLong(player);
            return;
        }
        party.addMember(player.uuid());
        this.messages.partyCreated(player, party.name());
    }

    private void invitePlayer(CommandContext<PlayerCommander> ctx) {
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        CarbonPlayer recipient = (CarbonPlayer)ctx.get("player");
        if (recipient.uuid().equals(player.uuid())) {
            this.messages.cannotInviteSelf(player);
            return;
        }
        @Nullable Party party = player.party().join();
        if (party == null) {
            this.messages.mustBeInParty(player);
            return;
        }
        @Nullable Party recipientParty = recipient.party().join();
        if (recipientParty != null && recipientParty.id().equals(party.id())) {
            this.messages.alreadyInParty(player, recipient.displayName());
            return;
        }
        this.partyInvites.sendInvite(player.uuid(), recipient.uuid(), party.id());
        this.messages.receivedPartyInvite(recipient, player.displayName(), player.username(), party.name());
        this.messages.sentPartyInvite(player, recipient.displayName(), party.name());
    }

    private void acceptInvite(CommandContext<PlayerCommander> ctx) {
        @Nullable CarbonPlayer sender = (CarbonPlayer)ctx.getOrDefault("sender", null);
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        @Nullable Invite invite = this.findInvite(player, sender);
        if (invite == null) {
            return;
        }
        @Nullable Party old = player.party().join();
        if (old != null) {
            this.messages.mustLeavePartyFirst(player);
            return;
        }
        this.partyInvites.invalidateInvite(invite.sender(), player.uuid());
        invite.party().addMember(player.uuid());
        this.messages.joinedParty(player, invite.party().name());
    }

    private void leaveParty(CommandContext<PlayerCommander> ctx) {
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        @Nullable Party old = player.party().join();
        if (old == null) {
            this.messages.mustBeInParty(player);
            return;
        }
        if (old.members().size() == 1) {
            this.disbandParty(ctx);
            return;
        }
        old.removeMember(player.uuid());
        this.messages.leftParty(player, old.name());
    }

    private void disbandParty(CommandContext<PlayerCommander> ctx) {
        CarbonPlayer player = ((PlayerCommander)ctx.sender()).carbonPlayer();
        @Nullable Party old = player.party().join();
        if (old == null) {
            this.messages.mustBeInParty(player);
            return;
        }
        if (old.members().size() != 1) {
            this.messages.cannotDisbandParty(player, old.name());
            return;
        }
        old.disband();
        this.messages.disbandedParty(player, old.name());
    }

    private @Nullable Invite findInvite(CarbonPlayer player, @Nullable CarbonPlayer sender) {
        Map map;
        @Nullable Cache<UUID, UUID> cache = this.partyInvites.invitesFor(player.uuid());
        Map map2 = map = cache != null ? Map.copyOf(cache.asMap()) : null;
        if (map == null || map.isEmpty()) {
            this.messages.noPendingPartyInvites(player);
            return null;
        }
        if (sender != null) {
            @Nullable Party p = Optional.ofNullable((UUID)map.get(sender.uuid())).map(id -> this.userManager.party((UUID)id).join()).orElse(null);
            if (p == null) {
                this.messages.noPartyInviteFrom(player, sender.displayName());
                return null;
            }
            return new Invite(sender.uuid(), p);
        }
        if (map.size() == 1) {
            Map.Entry e = map.entrySet().iterator().next();
            @Nullable Party p = this.userManager.party((UUID)e.getValue()).join();
            if (p == null) {
                this.messages.noPendingPartyInvites(player);
                return null;
            }
            return new Invite((UUID)e.getKey(), p);
        }
        this.messages.mustSpecifyPartyInvite(player);
        return null;
    }

    private record Invite(UUID sender, Party party) {
    }
}

