/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.UUID;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.command.commands.WhisperCommand;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.signed.SignedGreedyStringParser;
import org.incendo.cloud.minecraft.signed.SignedString;
import org.incendo.cloud.parser.ParserDescriptor;

@DefaultQualifier(value=NonNull.class)
public final class ReplyCommand
extends CarbonCommand {
    private final UserManager<?> users;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages messages;
    private final WhisperCommand.WhisperHandler whisper;

    @Inject
    public ReplyCommand(UserManager<?> userManager, CommandManager<Commander> commandManager, CarbonMessages messages, WhisperCommand.WhisperHandler whisper) {
        this.users = userManager;
        this.commandManager = commandManager;
        this.messages = messages;
        this.whisper = whisper;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("reply", "r");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"reply");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).required("message", (ParserDescriptor)SignedGreedyStringParser.signedGreedyStringParser(), (Description)RichDescription.richDescription((ComponentLike)this.messages.commandReplyArgumentMessage())).permission("carbon.whisper.reply").senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messages.commandReplyDescription())).handler(ctx -> {
            CarbonPlayer sender = ((PlayerCommander)ctx.sender()).carbonPlayer();
            if (sender.muted()) {
                this.messages.muteCannotSpeak(sender);
                return;
            }
            SignedString message = (SignedString)ctx.get("message");
            @Nullable UUID replyTarget = sender.whisperReplyTarget();
            if (replyTarget == null) {
                this.messages.replyTargetNotSet(sender, sender.displayName());
                return;
            }
            @MonotonicNonNull CarbonPlayer recipient = (CarbonPlayer)this.users.user(replyTarget).join();
            this.whisper.whisper(sender, recipient, message);
        }).build();
        this.commandManager.command(command);
    }
}

