/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;

public class ToggleMessagesCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;

    @Inject
    public ToggleMessagesCommand(CommandManager<Commander> commandManager, CarbonMessages carbonMessages) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("togglemsg", "togglepm");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"togglemsg");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).permission("carbon.togglemsg").senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandToggleMsgDescription())).handler(handler -> {
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            boolean nowIgnoring = !sender.ignoringDirectMessages();
            sender.ignoringDirectMessages(nowIgnoring);
            if (nowIgnoring) {
                this.carbonMessages.whispersToggledOff(sender);
            } else {
                this.carbonMessages.whispersToggledOn(sender);
            }
        }).build();
        this.commandManager.command(command);
        Command toggleOn = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).permission("carbon.togglemsg").literal("on", new String[]{"allow"}).senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandToggleMsgDescription())).handler(handler -> {
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            sender.ignoringDirectMessages(false);
            this.carbonMessages.whispersToggledOn(sender);
        }).build();
        this.commandManager.command(toggleOn);
        Command toggleOff = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).permission("carbon.togglemsg").literal("off", new String[]{"ignore"}).senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandToggleMsgDescription())).handler(handler -> {
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            sender.ignoringDirectMessages(true);
            this.carbonMessages.whispersToggledOff(sender);
        }).build();
        this.commandManager.command(toggleOff);
    }
}

