/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.UUID;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.UUIDParser;

@DefaultQualifier(value=NonNull.class)
public final class UnmuteCommand
extends CarbonCommand {
    private final UserManager<?> users;
    private final CarbonServer server;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final ParserFactory parserFactory;

    @Inject
    public UnmuteCommand(UserManager<?> userManager, CarbonServer server, CommandManager<Commander> commandManager, CarbonMessages carbonMessages, ParserFactory parserFactory) {
        this.users = userManager;
        this.server = server;
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.parserFactory = parserFactory;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("unmute", new String[0]);
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"unmute");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).optional("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandUnmuteArgumentPlayer())).flag(this.commandManager.flagBuilder("uuid").withAliases(new String[]{"u"}).withDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandUnmuteArgumentUUID())).withComponent(UUIDParser.uuidParser())).permission("carbon.mute.unmute").senderType(Commander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandUnmuteDescription())).handler(handler -> {
            CarbonPlayer target;
            Commander sender = (Commander)handler.sender();
            if (handler.contains("player")) {
                target = (CarbonPlayer)handler.get("player");
            } else if (handler.flags().contains("uuid")) {
                target = (CarbonPlayer)this.users.user((UUID)handler.flags().get("uuid")).join();
            } else {
                this.carbonMessages.unmuteNoTarget(sender);
                return;
            }
            this.carbonMessages.unmuteAlertRecipient(target);
            this.carbonMessages.unmuteAlertPlayers(this.server.console(), target.displayName());
            for (CarbonPlayer carbonPlayer : this.server.players()) {
                if (carbonPlayer.equals(target) || !carbonPlayer.hasPermission("carbon.mute.notify")) continue;
                this.carbonMessages.unmuteAlertPlayers(carbonPlayer, target.displayName());
            }
            target.muted(false);
        }).build();
        this.commandManager.command(command);
    }
}

