/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.Objects;
import java.util.UUID;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.UUIDParser;

@DefaultQualifier(value=NonNull.class)
public final class UpdateUsernameCommand
extends CarbonCommand {
    private final UserManager<?> userManager;
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages messageService;
    private final ParserFactory parserFactory;
    private final ProfileResolver profileResolver;

    @Inject
    public UpdateUsernameCommand(UserManager<?> userManager, CommandManager<Commander> commandManager, CarbonMessages messageService, ParserFactory parserFactory, ProfileResolver profileResolver) {
        this.userManager = userManager;
        this.commandManager = commandManager;
        this.messageService = messageService;
        this.parserFactory = parserFactory;
        this.profileResolver = profileResolver;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("updateusername", "updatename");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"updateusername");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).optional("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.messageService.commandUpdateUsernameArgumentPlayer())).flag(this.commandManager.flagBuilder("uuid").withAliases(new String[]{"u"}).withDescription((Description)RichDescription.richDescription((ComponentLike)this.messageService.commandUpdateUsernameArgumentUUID())).withComponent(UUIDParser.uuidParser())).permission("carbon.updateusername").senderType(Commander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.messageService.commandUpdateUsernameDescription())).handler(handler -> {
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            CarbonPlayer target = handler.contains("player") ? (CarbonPlayer)handler.get("player") : (handler.flags().contains("uuid") ? (CarbonPlayer)this.userManager.user((UUID)handler.flags().get("uuid")).join() : sender);
            if (target instanceof WrappedCarbonPlayer) {
                WrappedCarbonPlayer wrappedPlayer = (WrappedCarbonPlayer)target;
                target = wrappedPlayer.carbonPlayerCommon();
            } else if (!(target instanceof CarbonPlayerCommon)) {
                this.messageService.usernameNotUpdated(sender);
                return;
            }
            this.messageService.usernameFetching(sender);
            CarbonPlayer finalTarget = target;
            this.profileResolver.resolveName(target.uuid()).thenAccept(name -> {
                Objects.requireNonNull(name, "Unable to fetch username for player.");
                ((CarbonPlayerCommon)finalTarget).username((String)name);
                this.messageService.usernameUpdated(sender, (String)name);
            });
        }).build();
        this.commandManager.command(command);
    }
}

