/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.RawChat;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.command.argument.CarbonPlayerParser;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.event.events.CarbonPrivateChatEventImpl;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.messaging.packets.WhisperPacket;
import net.draycia.carbon.common.users.NetworkUsers;
import net.draycia.carbon.common.util.CloudUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.apache.logging.log4j.Logger;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.signed.SignedGreedyStringParser;
import org.incendo.cloud.minecraft.signed.SignedString;
import org.incendo.cloud.parser.ParserDescriptor;

@DefaultQualifier(value=NonNull.class)
public final class WhisperCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final ParserFactory parserFactory;
    private final WhisperHandler whisper;

    @Inject
    public WhisperCommand(CommandManager<Commander> commandManager, CarbonMessages carbonMessages, ParserFactory parserFactory, WhisperHandler whisper) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.parserFactory = parserFactory;
        this.whisper = whisper;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("whisper", "w", "message", "msg", "m", "tell");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"whisper");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).required("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandWhisperArgumentPlayer())).required("message", (ParserDescriptor)SignedGreedyStringParser.signedGreedyStringParser(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandWhisperArgumentMessage())).permission("carbon.whisper.message").senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandWhisperDescription())).handler(ctx -> {
            CarbonPlayer sender = ((PlayerCommander)ctx.sender()).carbonPlayer();
            if (sender.muted()) {
                this.carbonMessages.muteCannotSpeak(sender);
                return;
            }
            SignedString message = (SignedString)ctx.get("message");
            CarbonPlayer recipient = (CarbonPlayer)ctx.get("player");
            this.whisper.whisper(sender, recipient, message, ctx.parsingContext("player").consumedInput());
        }).build();
        this.commandManager.command(command);
    }

    public static void broadcastWhisperSpy(CarbonServer server, CarbonMessages messages, String senderUsername, Component senderDisplayName, String recipientUsername, Component recipientDisplayName, Component message) {
        for (CarbonPlayer carbonPlayer : server.players()) {
            if (!carbonPlayer.spying() || carbonPlayer.username().equals(senderUsername) || carbonPlayer.username().equals(recipientUsername)) continue;
            messages.whisperRecipientSpy(carbonPlayer, senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, message);
        }
    }

    public static final class WhisperHandler {
        private final Logger logger;
        private final CarbonMessages messages;
        private final ConfigManager configManager;
        private final Provider<MessagingManager> messaging;
        private final PacketFactory packetFactory;
        private final UserManager<? extends CarbonPlayer> userManager;
        private final CarbonServer server;
        private final CarbonEventHandler events;
        private final NetworkUsers network;
        private final Key rawChatKey;

        @Inject
        private WhisperHandler(Logger logger, CarbonMessages messages, ConfigManager configManager, Provider<MessagingManager> messaging, PacketFactory packetFactory, UserManager<?> userManager, CarbonServer server, CarbonEventHandler events, NetworkUsers network, @RawChat Key rawChatKey) {
            this.logger = logger;
            this.messages = messages;
            this.configManager = configManager;
            this.messaging = messaging;
            this.packetFactory = packetFactory;
            this.userManager = userManager;
            this.server = server;
            this.events = events;
            this.network = network;
            this.rawChatKey = rawChatKey;
        }

        public void whisper(CarbonPlayer sender, CarbonPlayer recipient, SignedString message) {
            this.whisper(sender, recipient, message, null);
        }

        public void whisper(CarbonPlayer sender, CarbonPlayer recipient, SignedString message, @Nullable String recipientInputString) {
            if (sender.equals(recipient)) {
                this.messages.whisperSelfError(sender, sender.displayName());
                return;
            }
            if (sender.ignoringDirectMessages() && !sender.hasPermission("carbon.togglemsg.exempt")) {
                this.messages.whisperIgnoringAll(sender);
                return;
            }
            if (!sender.hasPermission("carbon.whisper.send")) {
                this.messages.whisperNoPermissionSend(sender);
                return;
            }
            String recipientUsername = recipient.username();
            if (!this.network.online(recipient) || !sender.awareOf(recipient) && !sender.hasPermission("carbon.whisper.vanished")) {
                CarbonPlayerParser.ParseException exception = new CarbonPlayerParser.ParseException(recipientInputString == null ? recipientUsername : recipientInputString, this.messages);
                this.messages.errorCommandArgumentParsing(sender, CloudUtils.message(exception));
                return;
            }
            boolean localRecipient = recipient.online();
            if (sender.ignoring(recipient)) {
                this.messages.whisperIgnoringTarget(sender, recipient.displayName());
                return;
            }
            if (recipient.ignoring(sender)) {
                this.messages.whisperTargetIgnoring(sender, recipient.displayName());
                return;
            }
            if (recipient.ignoringDirectMessages() && !sender.hasPermission("carbon.togglemsg.exempt")) {
                this.messages.whisperTargetIgnoringDMs(sender, recipient.displayName());
                return;
            }
            Component senderDisplayName = sender.displayName();
            Component recipientDisplayName = recipient.displayName();
            CarbonPrivateChatEventImpl privateChatEvent = new CarbonPrivateChatEventImpl(sender, recipient, (Component)Component.text((String)message.string()));
            this.events.emit(privateChatEvent);
            if (privateChatEvent.cancelled()) {
                this.messages.whisperError(sender, sender.displayName(), recipient.displayName());
                return;
            }
            String senderUsername = sender.username();
            message.sendMessage((Audience)sender, ChatType.chatType((Keyed)this.rawChatKey), this.messages.whisperSender(SourcedAudience.of(sender, sender), senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, recipient.uuid(), privateChatEvent.message()));
            if (localRecipient) {
                if (!recipient.hasPermission("carbon.whisper.receive")) {
                    this.messages.whisperNoPermissionReceive(sender);
                    return;
                }
                message.sendMessage((Audience)recipient, ChatType.chatType((Keyed)this.rawChatKey), this.messages.whisperRecipient(SourcedAudience.of(sender, recipient), senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, recipient.uuid(), privateChatEvent.message()));
            }
            WhisperCommand.broadcastWhisperSpy(this.server, this.messages, senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, privateChatEvent.message());
            this.messages.whisperConsoleLog(this.server.console(), senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, privateChatEvent.message());
            @Nullable Sound messageSound = this.configManager.primaryConfig().messageSound();
            if (localRecipient && messageSound != null) {
                recipient.playSound(messageSound);
            }
            sender.lastWhisperTarget(recipient.uuid());
            sender.whisperReplyTarget(recipient.uuid());
            if (localRecipient) {
                recipient.whisperReplyTarget(sender.uuid());
            } else {
                ((MessagingManager)this.messaging.get()).queuePacket(() -> this.packetFactory.whisperPacket(sender.uuid(), recipient.uuid(), privateChatEvent.message()));
            }
        }

        public void handlePacket(WhisperPacket packet) {
            @Nullable CarbonPlayer recipient = this.server.players().stream().filter(p -> p.uuid().equals(packet.to())).findFirst().orElse(null);
            if (recipient == null) {
                return;
            }
            ((CompletableFuture)this.userManager.user(packet.from()).thenAccept(sender -> {
                String senderUsername = sender.username();
                Component senderDisplayName = sender.displayName();
                String recipientUsername = recipient.username();
                Component recipientDisplayName = recipient.displayName();
                if (!recipient.hasPermission("carbon.whisper.receive")) {
                    this.messages.whisperNoPermissionReceive((Audience)sender);
                    return;
                }
                recipient.whisperReplyTarget(sender.uuid());
                SourcedAudience.of(sender, recipient).sendMessage(this.messages.whisperRecipient(SourcedAudience.of(sender, recipient), senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, recipient.uuid(), packet.message()));
                WhisperCommand.broadcastWhisperSpy(this.server, this.messages, senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, packet.message());
                this.messages.whisperConsoleLog(this.server.console(), senderUsername, senderDisplayName, recipientUsername, recipientDisplayName, packet.message());
                @Nullable Sound messageSound = this.configManager.primaryConfig().messageSound();
                if (messageSound != null) {
                    recipient.playSound(messageSound);
                }
            })).exceptionally(ex -> {
                this.logger.warn("Failed to handle whisper packet {}", (Object)packet, ex);
                return null;
            });
        }
    }
}

