/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.config;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.CommentedConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.CommentedConfigurationNodeIntermediary;
import carbonchat.libs.org.spongepowered.configurate.ConfigurateException;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import carbonchat.libs.org.spongepowered.configurate.loader.ConfigurationLoader;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ObjectMapper;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Comment;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Processor;
import carbonchat.libs.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import io.leangen.geantyref.GenericTypeReflector;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.config.CommandConfig;
import net.draycia.carbon.common.config.ConfigHeader;
import net.draycia.carbon.common.config.IntegrationConfigContainer;
import net.draycia.carbon.common.config.PrimaryConfig;
import net.draycia.carbon.common.event.events.CarbonReloadEvent;
import net.draycia.carbon.common.integration.Integration;
import net.draycia.carbon.common.serialisation.gson.LocaleSerializerConfigurate;
import net.draycia.carbon.common.util.FileUtil;
import net.kyori.adventure.key.Key;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class ConfigManager {
    public static final String CONFIG_VERSION_KEY = "config-version";
    private static final String PRIMARY_CONFIG_FILE_NAME = "config.conf";
    private static final String COMMAND_SETTINGS_FILE_NAME = "command-settings.conf";
    private final Path dataDirectory;
    private final LocaleSerializerConfigurate locale;
    private final Logger logger;
    private final Set<Integration.ConfigMeta> integrations;
    private volatile @MonotonicNonNull PrimaryConfig primaryConfig = null;

    @Inject
    private ConfigManager(CarbonEventHandler events, @DataDirectory Path dataDirectory, LocaleSerializerConfigurate locale, Logger logger, Set<Integration.ConfigMeta> integrations) {
        this.dataDirectory = dataDirectory;
        this.locale = locale;
        this.logger = logger;
        this.integrations = integrations;
        events.subscribe(CarbonReloadEvent.class, -100, true, event -> this.reloadPrimaryConfig());
    }

    public static @Nullable String extractHeader(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            @Nullable ConfigHeader h = cls.getAnnotation(ConfigHeader.class);
            if (h == null) {
                return null;
            }
            return h.value();
        }
        return ConfigManager.extractHeader(GenericTypeReflector.erase((Type)type));
    }

    public void reloadPrimaryConfig() {
        this.logger.info("Reloading configuration....");
        @Nullable PrimaryConfig load = this.load(PrimaryConfig.class, PRIMARY_CONFIG_FILE_NAME);
        if (load != null) {
            this.primaryConfig = load;
        } else {
            this.logger.error("Failed to reload primary config, see above for further details");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryConfig primaryConfig() {
        if (this.primaryConfig == null) {
            ConfigManager configManager = this;
            synchronized (configManager) {
                if (this.primaryConfig == null) {
                    this.logger.info("Loading configuration....");
                    @Nullable PrimaryConfig load = this.load(PrimaryConfig.class, PRIMARY_CONFIG_FILE_NAME);
                    if (load == null) {
                        throw new RuntimeException("Failed to initialize primary config, see above for further details");
                    }
                    this.primaryConfig = load;
                }
            }
        }
        return this.primaryConfig;
    }

    public Map<Key, CommandSettings> loadCommandSettings() {
        @Nullable CommandConfig load = this.load(CommandConfig.class, COMMAND_SETTINGS_FILE_NAME);
        if (load == null) {
            throw new RuntimeException("Failed to initialize command settings, see above for further details");
        }
        return load.settings();
    }

    public ConfigurationLoader<?> configurationLoader(Path file, @Nullable String header) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().prettyPrinting(true).defaultOptions(opts -> {
            ConfigurateComponentSerializer serializer = ConfigurateComponentSerializer.configurate();
            return opts.shouldCopyDefaults(true).header(header).serializers(serializerBuilder -> serializerBuilder.registerAll(serializer.serializers()).register(Locale.class, this.locale).register(IntegrationConfigContainer.class, new IntegrationConfigContainer.Serializer(this.integrations)).registerAnnotatedObjects(ObjectMapper.factoryBuilder().addProcessor(Comment.class, ConfigManager.overrideComments()).build()));
        })).path(file)).build();
    }

    private static Processor.Factory<Comment, Object> overrideComments() {
        return (data, fieldType) -> (value, destination) -> {
            if (destination instanceof CommentedConfigurationNodeIntermediary) {
                CommentedConfigurationNodeIntermediary commented = (CommentedConfigurationNodeIntermediary)destination;
                commented.comment(data.value());
            }
        };
    }

    public <T> @Nullable T load(Class<T> clazz, String fileName) {
        Path file = this.dataDirectory.resolve(fileName);
        try {
            FileUtil.mkParentDirs(file);
        }
        catch (IOException ex) {
            this.logger.error("Failed to create parent directories for '{}'", (Object)file, (Object)ex);
            return null;
        }
        ConfigurationLoader<?> loader = this.configurationLoader(file, ConfigManager.extractHeader(clazz));
        try {
            Object node = loader.load();
            try {
                clazz.getDeclaredMethod("upgrade", ConfigurationNode.class).invoke(null, node);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            @Nullable T config = node.get(clazz);
            if (config == null) {
                throw new ConfigurateException((ConfigurationNode)node, "Failed to deserialize " + clazz.getName() + " from node");
            }
            node.set(clazz, config);
            loader.save((ConfigurationNode)node);
            return config;
        }
        catch (ConfigurateException | ReflectiveOperationException exception) {
            this.logger.error("Failed to load config '{}'", (Object)file, (Object)exception);
            return null;
        }
    }

    public static <N extends ConfigurationNode> void configVersionComment(N rootNode, ConfigurationTransformation.Versioned versionedTransformation) {
        ConfigurationNode versionNode = rootNode.node(versionedTransformation.versionKey());
        if (!versionNode.virtual() && versionNode instanceof CommentedConfigurationNode) {
            CommentedConfigurationNode commented = (CommentedConfigurationNode)versionNode;
            commented.comment("Used internally to track changes to the config. Do not edit manually!");
        }
    }
}

