/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.config;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Comment;
import java.util.concurrent.TimeUnit;

@DefaultQualifier(value=Nullable.class)
@ConfigSerializable
public class DatabaseSettings {
    @Comment(value="JDBC URL. Suggested defaults for each DB:\nMySQL: jdbc:mysql://host:3306/DB\nMariaDB: jdbc:mariadb://host:3306/DB\nPostgreSQL: jdbc:postgresql://host:5432/database")
    private String url = "jdbc:mysql://localhost:3306/carbon";
    @Comment(value="The connection username.")
    private String username = "username";
    @Comment(value="The connection password.")
    private String password = "password";
    @Comment(value="Settings for the connection pool. This is an advanced configuration that most users won't need to touch.")
    private ConnectionPool connectionPool = new ConnectionPool();

    public DatabaseSettings() {
    }

    public DatabaseSettings(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String url() {
        return this.url;
    }

    public String url(String url) {
        this.url = url;
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    @ConfigSerializable
    public static class ConnectionPool {
        public int maximumPoolSize = 8;
        public int minimumIdle = 8;
        public long maximumLifetime = TimeUnit.MINUTES.toMillis(30L);
        public long keepaliveTime = 0L;
        public long connectionTimeout = TimeUnit.SECONDS.toMillis(30L);
    }
}

