/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.config;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.BasicConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationOptions;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.draycia.carbon.common.integration.Integration;
import net.draycia.carbon.common.util.Exceptions;

@DefaultQualifier(value=NonNull.class)
public final class IntegrationConfigContainer {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public <C> C config(Integration.ConfigMeta meta) {
        return (C)Objects.requireNonNull(this.map.get(meta.name()));
    }

    public static final class Serializer
    implements TypeSerializer<IntegrationConfigContainer> {
        private final List<Integration.ConfigMeta> sections;

        public Serializer(Set<Integration.ConfigMeta> integrations) {
            this.sections = integrations.stream().sorted(Comparator.comparing(Integration.ConfigMeta::name)).toList();
        }

        @Override
        public IntegrationConfigContainer deserialize(Type type, ConfigurationNode node) throws SerializationException {
            IntegrationConfigContainer container = new IntegrationConfigContainer();
            for (Integration.ConfigMeta section : this.sections) {
                @Nullable Object value = node.node(section.name()).get(section.type());
                Objects.requireNonNull(value);
                container.map.put(section.name(), value);
            }
            return container;
        }

        @Override
        public void serialize(Type type, @Nullable IntegrationConfigContainer obj, ConfigurationNode node) throws SerializationException {
            Objects.requireNonNull(obj);
            for (Object key : node.childrenMap().keySet()) {
                node.removeChild(key);
            }
            for (Integration.ConfigMeta section : this.sections) {
                node.node(section.name()).set(section.type(), obj.map.get(section.name()));
            }
        }

        @Override
        public IntegrationConfigContainer emptyValue(Type specificType, ConfigurationOptions options) {
            IntegrationConfigContainer container = new IntegrationConfigContainer();
            for (Integration.ConfigMeta section : this.sections) {
                Object value;
                try {
                    value = options.serializers().get(section.type()).deserialize(section.type(), (ConfigurationNode)BasicConfigurationNode.root());
                }
                catch (Exception e) {
                    throw Exceptions.rethrow(e);
                }
                Objects.requireNonNull(value);
                container.map.put(section.name(), value);
            }
            return container;
        }
    }
}

