/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.config;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.ConfigurateException;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.NodePath;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Comment;
import carbonchat.libs.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.draycia.carbon.common.config.ClearChatSettings;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.config.DatabaseSettings;
import net.draycia.carbon.common.config.IntegrationConfigContainer;
import net.draycia.carbon.common.config.MessagingSettings;
import net.draycia.carbon.common.config.PingSettings;
import net.draycia.carbon.common.util.Exceptions;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;

@ConfigSerializable
@DefaultQualifier(value=NonNull.class)
public class PrimaryConfig {
    @Comment(value="The default locale for plugin messages.")
    private Locale defaultLocale = Locale.US;
    @Comment(value="The default channel that new players will be in when they join.\nIf the channel is not found or the player cannot use the channel, they will speak in basic non-channel chat.")
    private Key defaultChannel = Key.key((String)"carbon", (String)"global");
    @Comment(value="Returns you to the default channel when you use a channel's command while you have that channel active.")
    private boolean returnToDefaultChannel = false;
    @Comment(value="The service that will be used to store and load player information.\nOne of: JSON, H2, MYSQL, PSQL\nNote: If you choose MYSQL or PSQL make sure you configure the \"database-settings\" section of this file!")
    private StorageType storageType = StorageType.JSON;
    @Comment(value="When \"storage-type\" is set to MYSQL or PSQL, this section configures the database connection.\nIf JSON or H2 storage is used, this section can be ignored.")
    private DatabaseSettings databaseSettings = new DatabaseSettings();
    @Comment(value="Settings for cross-server messaging")
    private MessagingSettings messagingSettings = new MessagingSettings();
    private NicknameSettings nicknameSettings = new NicknameSettings();
    @Comment(value="Plugin-wide custom placeholders.\nThese will be parsed in all messages rendered and sent by Carbon.\nThis includes chat, command feedback, and others.\nMake sure to close your tags so they do not bleed into other formats.\nOnly a single pass is done so custom placeholders will not work within each other.")
    private Map<String, String> customPlaceholders = Map.of();
    @Comment(value="The suggestions shown when using the TAB key in chat.")
    private List<String> customChatSuggestions = List.of();
    @Comment(value="The placeholders replaced in chat messages, this WILL work with chat previews.")
    private Map<String, String> chatPlaceholders = Map.of();
    @Comment(value="Basic regex based chat filter.")
    private Map<String, String> chatFilter = Map.of();
    @Comment(value="Player toggled chat filter. Useful for more mild profanity.")
    private Map<String, String> optionalChatFilter = Map.of();
    @Comment(value="Various settings related to pinging players in channels.")
    private PingSettings pingSettings = new PingSettings();
    private PartySettings partyChat = new PartySettings();
    @Comment(value="Sound for receiving a direct message")
    private @Nullable Sound messageSound = Sound.sound((Key)Key.key((String)"entity.experience_orb.pickup"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
    @Comment(value="Settings for the clear chat command")
    private ClearChatSettings clearChatSettings = new ClearChatSettings();
    @Comment(value="Settings for integrations with other plugins/mods. Settings only apply when the relevant plugin/mod is present.")
    private IntegrationConfigContainer integrations;
    @Comment(value="Whether Carbon should check for updates using the GitHub API on startup.")
    private boolean updateChecker = true;

    public NicknameSettings nickname() {
        return this.nicknameSettings;
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public Key defaultChannel() {
        return this.defaultChannel;
    }

    public boolean returnToDefaultChannel() {
        return this.returnToDefaultChannel;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public DatabaseSettings databaseSettings() {
        return this.databaseSettings;
    }

    public MessagingSettings messagingSettings() {
        return this.messagingSettings;
    }

    public String applyCustomPlaceholders(String string) {
        String placeholderResolvedMessage = string;
        for (Map.Entry<String, String> entry : this.customPlaceholders.entrySet()) {
            placeholderResolvedMessage = placeholderResolvedMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return placeholderResolvedMessage;
    }

    public @Nullable List<String> customChatSuggestions() {
        return this.customChatSuggestions;
    }

    public String applyChatPlaceholders(String string) {
        String placeholderResolvedMessage = string;
        for (Map.Entry<String, String> entry : this.chatPlaceholders.entrySet()) {
            placeholderResolvedMessage = placeholderResolvedMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return placeholderResolvedMessage;
    }

    public String applyChatFilters(String string) {
        String filteredMessage = string;
        for (Map.Entry<String, String> entry : this.chatFilter.entrySet()) {
            filteredMessage = filteredMessage.replaceAll(entry.getKey(), entry.getValue());
        }
        return filteredMessage;
    }

    public Component applyOptionalChatFilters(Component message) {
        Component filteredMessage = message;
        for (Map.Entry<String, String> entry : this.optionalChatFilter.entrySet()) {
            filteredMessage = filteredMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(entry.getKey()).replacement(entry.getValue()).build());
        }
        return filteredMessage;
    }

    public PingSettings pings() {
        return this.pingSettings;
    }

    public PartySettings partyChat() {
        return this.partyChat;
    }

    public @Nullable Sound messageSound() {
        return this.messageSound;
    }

    public ClearChatSettings clearChatSettings() {
        return this.clearChatSettings;
    }

    public IntegrationConfigContainer integrations() {
        return this.integrations;
    }

    public boolean updateChecker() {
        return this.updateChecker;
    }

    public static void upgrade(ConfigurationNode node) {
        ConfigurationTransformation.VersionedBuilder builder = ConfigurationTransformation.versionedBuilder().versionKey("config-version");
        ConfigurationTransformation initial = ConfigurationTransformation.builder().addAction(NodePath.path("use-carbon-nicknames"), (path, value) -> new Object[]{"nickname-settings", "use-carbon-nicknames"}).build();
        builder.addVersion(0, initial);
        ConfigurationTransformation one = ConfigurationTransformation.builder().addAction(NodePath.path("party-chat"), (path, value) -> new Object[]{"party-chat", "enabled"}).build();
        builder.addVersion(1, one);
        ConfigurationTransformation.Versioned upgrader = builder.build();
        int from = upgrader.version(node);
        try {
            upgrader.apply(node);
        }
        catch (ConfigurateException e) {
            Exceptions.rethrow(e);
        }
        ConfigManager.configVersionComment(node, upgrader);
    }

    public static enum StorageType {
        JSON,
        MYSQL,
        PSQL,
        H2;

    }

    @ConfigSerializable
    public static final class NicknameSettings {
        @Comment(value="Whether Carbon's nickname management should be used. Disable this if you wish to have another plugin manage nicknames.")
        private boolean useCarbonNicknames = true;
        @Comment(value="Paper only. Updates the player's display name in the tab list to match their nickname.")
        private boolean updateTabList = true;
        @Comment(value="Minimum number of characters in nickname (excluding formatting).")
        private int minLength = 3;
        @Comment(value="Maximum number of characters in nickname (excluding formatting).")
        private int maxLength = 16;
        private List<String> blackList = List.of("notch", "admin");
        @Comment(value="Regex pattern nicknames must match in order to be applied, can be bypassed with the permission 'carbon.nickname.filter'.")
        private String filter = "^[a-zA-Z0-9_]*$";
        @Comment(value="Format used when displaying nicknames.")
        public String format = "<hover:show_text:'<gray>@</gray><username>'><gray>~</gray><nickname></hover>";
        @Comment(value="Whether to skip applying 'format' when a nickname matches a players username, only differing in decoration.")
        public boolean skipFormatWhenNameMatches = true;

        public boolean useCarbonNicknames() {
            return this.useCarbonNicknames;
        }

        public boolean updateTabList() {
            return this.updateTabList;
        }

        public List<String> blackList() {
            return this.blackList;
        }

        public String filter() {
            return this.filter;
        }

        public int minLength() {
            return this.minLength;
        }

        public int maxLength() {
            return this.maxLength;
        }
    }

    @ConfigSerializable
    public static final class PartySettings {
        @Comment(value="Whether party chat is enabled")
        public boolean enabled = true;
        public int expireInvitesAfterSeconds = 45;
        public boolean playSound = false;
        @Comment(value="Sound for receiving a party message")
        public @Nullable Sound messageSound = Sound.sound((Key)Key.key((String)"entity.experience_orb.pickup"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
    }
}

