/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.event;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.com.seiama.event.EventConfig;
import carbonchat.libs.com.seiama.event.EventSubscriber;
import carbonchat.libs.com.seiama.event.EventSubscription;
import carbonchat.libs.com.seiama.event.bus.EventBus;
import carbonchat.libs.com.seiama.event.bus.SimpleEventBus;
import carbonchat.libs.com.seiama.event.registry.EventRegistry;
import carbonchat.libs.com.seiama.event.registry.SimpleEventRegistry;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import net.draycia.carbon.api.event.Cancellable;
import net.draycia.carbon.api.event.CarbonEvent;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.CarbonEventSubscriber;
import net.draycia.carbon.api.event.CarbonEventSubscription;
import net.draycia.carbon.common.event.CarbonEventSubscriptionImpl;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class CarbonEventHandlerImpl
implements CarbonEventHandler {
    private final Logger logger;
    private final EventRegistry<CarbonEvent> eventRegistry = new SimpleEventRegistry<CarbonEvent>(CarbonEvent.class);
    private final EventBus<CarbonEvent> eventBus = new SimpleEventBus<CarbonEvent>(this.eventRegistry, this::onException);

    @Inject
    private CarbonEventHandlerImpl(Logger logger) {
        this.logger = logger;
    }

    private <E> void onException(EventBus<? super E> eventBus, EventSubscription<? super E> subscription, E event, Throwable throwable) {
        Object object;
        EventSubscriber<? super E> eventSubscriber = subscription.subscriber();
        if (eventSubscriber instanceof SubscriberWrapper) {
            SubscriberWrapper wrapped = (SubscriberWrapper)eventSubscriber;
            object = wrapped.carbon;
        } else {
            object = subscription.subscriber();
        }
        EventSubscriber<? super E> subscriber = object;
        this.logger.warn("Exception posting event '{}' to subscriber '{}'", event, subscriber, (Object)throwable);
    }

    @Override
    public <T extends CarbonEvent> CarbonEventSubscription<T> subscribe(Class<T> eventClass, CarbonEventSubscriber<T> subscriber) {
        return new CarbonEventSubscriptionImpl<T>(eventClass, subscriber, this.eventRegistry.subscribe(eventClass, new SubscriberWrapper<T>(subscriber, true)));
    }

    @Override
    public <T extends CarbonEvent> CarbonEventSubscription<T> subscribe(Class<T> eventClass, int order, boolean acceptsCancelled, CarbonEventSubscriber<T> subscriber) {
        EventConfig eventConfig = EventConfig.defaults().order(order).acceptsCancelled(acceptsCancelled);
        return new CarbonEventSubscriptionImpl<T>(eventClass, subscriber, this.eventRegistry.subscribe(eventClass, eventConfig, new SubscriberWrapper<T>(subscriber, acceptsCancelled)));
    }

    @Override
    public <T extends CarbonEvent> void emit(T event) {
        this.eventBus.post(event);
    }

    private record SubscriberWrapper<T extends CarbonEvent>(CarbonEventSubscriber<T> carbon, boolean acceptsCancelled) implements EventSubscriber<T>
    {
        @Override
        public void on(T event) throws Throwable {
            Cancellable cancellable;
            if (!this.acceptsCancelled && event instanceof Cancellable && (cancellable = (Cancellable)event).cancelled()) {
                return;
            }
            this.carbon.on(event);
        }
    }
}

