/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.event.events;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.KeyedRenderer;
import net.draycia.carbon.common.event.CancellableImpl;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public class CarbonChatEventImpl
extends CancellableImpl
implements CarbonChatEvent {
    private final List<KeyedRenderer> renderers;
    private final CarbonPlayer sender;
    private final Component originalMessage;
    private final List<? extends Audience> recipients;
    private final @MonotonicNonNull ChatChannel chatChannel;
    private final @MonotonicNonNull SignedMessage signedMessage;
    public final boolean origin;
    private Component message;

    public CarbonChatEventImpl(CarbonPlayer sender, Component originalMessage, List<? extends Audience> recipients, List<KeyedRenderer> renderers, @Nullable ChatChannel chatChannel, @Nullable SignedMessage signedMessage) {
        this(sender, originalMessage, recipients, renderers, chatChannel, signedMessage, true);
    }

    public CarbonChatEventImpl(CarbonPlayer sender, Component originalMessage, List<? extends Audience> recipients, List<KeyedRenderer> renderers, @Nullable ChatChannel chatChannel, @Nullable SignedMessage signedMessage, boolean origin) {
        this.sender = sender;
        this.originalMessage = originalMessage;
        this.message = originalMessage;
        this.recipients = recipients;
        this.renderers = renderers;
        this.chatChannel = chatChannel;
        this.signedMessage = signedMessage;
        this.origin = origin;
    }

    @Override
    public List<KeyedRenderer> renderers() {
        return this.renderers;
    }

    @Override
    public @MonotonicNonNull SignedMessage signedMessage() {
        return this.signedMessage;
    }

    @Override
    public CarbonPlayer sender() {
        return this.sender;
    }

    @Override
    public Component originalMessage() {
        return this.originalMessage;
    }

    @Override
    public Component message() {
        return this.message;
    }

    @Override
    public void message(Component message) {
        this.message = message;
    }

    @Override
    public @MonotonicNonNull ChatChannel chatChannel() {
        return this.chatChannel;
    }

    @Override
    public List<? extends Audience> recipients() {
        return this.recipients;
    }

    public Component renderFor(Audience viewer) {
        Component renderedMessage = this.message();
        for (KeyedRenderer renderer : this.renderers()) {
            renderedMessage = renderer.render(this.sender, viewer, renderedMessage, this.message());
        }
        return renderedMessage;
    }
}

