/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.integration.miniplaceholders;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.github.miniplaceholders.api.Expansion;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.integration.miniplaceholders.MiniPlaceholdersUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;

@DefaultQualifier(value=NonNull.class)
public final class MiniPlaceholdersExpansion {
    private final UserManager<?> userManager;
    private final ChannelRegistry channels;

    @Inject
    private MiniPlaceholdersExpansion(UserManager<?> userManager, ChannelRegistry channels) {
        this.userManager = userManager;
        this.channels = channels;
    }

    public static void register(Injector injector) {
        if (MiniPlaceholdersUtil.miniPlaceholdersLoaded()) {
            ((MiniPlaceholdersExpansion)injector.getInstance(MiniPlaceholdersExpansion.class)).registerExpansion();
        }
    }

    private void registerExpansion() {
        Expansion expansion = (Expansion)Expansion.builder((String)"carbonchat").audiencePlaceholder("party", (audience, queue, ctx) -> {
            if (!MiniPlaceholdersExpansion.hasId(audience)) {
                return null;
            }
            return Tag.selfClosingInserting((Component)this.partyName(MiniPlaceholdersExpansion.id(audience)));
        }).audiencePlaceholder("nickname", (audience, queue, ctx) -> {
            if (!MiniPlaceholdersExpansion.hasId(audience)) {
                return null;
            }
            return Tag.selfClosingInserting((Component)this.nickname(MiniPlaceholdersExpansion.id(audience)));
        }).audiencePlaceholder("displayname", (audience, queue, ctx) -> {
            if (!MiniPlaceholdersExpansion.hasId(audience)) {
                return null;
            }
            return Tag.selfClosingInserting((Component)this.displayName(MiniPlaceholdersExpansion.id(audience)));
        }).audiencePlaceholder("channel_key", (audience, queue, ctx) -> {
            if (!MiniPlaceholdersExpansion.hasId(audience)) {
                return null;
            }
            return Tag.preProcessParsed((String)this.selectedChannelKey(MiniPlaceholdersExpansion.id(audience)));
        }).build();
        expansion.register();
    }

    private static boolean hasId(Audience audience) {
        return audience.get(Identity.UUID).isPresent();
    }

    private static UUID id(Audience audience) {
        return (UUID)audience.get(Identity.UUID).orElseThrow();
    }

    private Component partyName(UUID id) {
        @Nullable Party party = (Party)((CompletableFuture)this.userManager.user(id).thenCompose(CarbonPlayer::party)).join();
        return party == null ? Component.empty() : party.name();
    }

    private Component displayName(UUID id) {
        CarbonPlayer carbonPlayer = (CarbonPlayer)this.userManager.user(id).join();
        return carbonPlayer.displayName();
    }

    private Component nickname(UUID id) {
        CarbonPlayer carbonPlayer = (CarbonPlayer)this.userManager.user(id).join();
        @Nullable Component nickname = carbonPlayer.nickname();
        return nickname == null ? Component.text((String)carbonPlayer.username()) : nickname;
    }

    private String selectedChannelKey(UUID id) {
        CarbonPlayer carbonPlayer = (CarbonPlayer)this.userManager.user(id).join();
        @Nullable ChatChannel selected = carbonPlayer.selectedChannel();
        if (selected != null) {
            return selected.key().asString();
        }
        return this.channels.defaultKey().asString();
    }
}

