/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.draycia.carbon.api.channels.ChannelPermissionResult;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.KeyedRenderer;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.event.events.CarbonChatEventImpl;
import net.draycia.carbon.common.event.events.CarbonEarlyChatEvent;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.TagPermissions;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentIteratorFlag;
import net.kyori.adventure.text.ComponentIteratorType;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

@DefaultQualifier(value=NonNull.class)
public abstract class ChatListenerInternal {
    private final ConfigManager configManager;
    private final CarbonMessages carbonMessages;
    private final CarbonEventHandler carbonEventHandler;

    protected ChatListenerInternal(CarbonEventHandler carbonEventHandler, CarbonMessages carbonMessages, ConfigManager configManager) {
        this.configManager = configManager;
        this.carbonMessages = carbonMessages;
        this.carbonEventHandler = carbonEventHandler;
    }

    protected @Nullable CarbonChatEventImpl prepareAndEmitChatEvent(CarbonPlayer sender, String messageContent, @Nullable SignedMessage signedMessage) {
        CarbonPlayer.ChannelMessage channelMessage = sender.channelForMessage((Component)Component.text((String)messageContent));
        ChatChannel channel = channelMessage.channel();
        String message = PlainTextComponentSerializer.plainText().serialize(channelMessage.message());
        return this.prepareAndEmitChatEvent(sender, message, signedMessage, channel);
    }

    protected @Nullable CarbonChatEventImpl prepareAndEmitChatEvent(CarbonPlayer sender, String messageContent, @Nullable SignedMessage signedMessage, ChatChannel channel) {
        Component message;
        ChannelPermissionResult permitted = channel.permissions().speechPermitted(sender);
        if (!permitted.permitted()) {
            sender.sendMessage(permitted.reason());
            return null;
        }
        if (!sender.hasPermission("carbon.cooldown.exempt") && channel.cooldown() > 0L) {
            long expiresAt;
            long currentMillis = System.currentTimeMillis();
            if (currentMillis < (expiresAt = channel.playerCooldown(sender))) {
                long remaining = (long)Math.ceil((double)(expiresAt - currentMillis) / 1000.0);
                this.carbonMessages.channelCooldown(sender, remaining);
                return null;
            }
            channel.startCooldown(sender);
        }
        String content = this.configManager.primaryConfig().applyChatPlaceholders(messageContent);
        CarbonEarlyChatEvent earlyChatEvent = new CarbonEarlyChatEvent(sender, content);
        this.carbonEventHandler.emit(earlyChatEvent);
        content = earlyChatEvent.message();
        if (sender instanceof WrappedCarbonPlayer) {
            WrappedCarbonPlayer wrapped = (WrappedCarbonPlayer)sender;
            message = wrapped.parseMessageTags(content);
        } else {
            message = TagPermissions.parseTags(sender, "carbon.messagetags", content, sender::hasPermission);
        }
        if (ChatListenerInternal.probablyBlank(message)) {
            return null;
        }
        if (sender.leftChannels().contains(channel.key())) {
            sender.joinChannel(channel);
            this.carbonMessages.channelJoined(sender);
        }
        ArrayList<KeyedRenderer> renderers = new ArrayList<KeyedRenderer>();
        renderers.add(KeyedRenderer.keyedRenderer(Key.key((String)"carbon", (String)"default"), channel));
        List<Audience> recipients = channel.recipients(sender);
        CarbonChatEventImpl chatEvent = new CarbonChatEventImpl(sender, message, recipients, renderers, channel, signedMessage);
        this.carbonEventHandler.emit(chatEvent);
        return chatEvent;
    }

    private static boolean probablyBlank(Component component) {
        Iterator it = component.iterator(ComponentIteratorType.DEPTH_FIRST, new ComponentIteratorFlag[0]);
        while (it.hasNext()) {
            Component c = (Component)it.next();
            if (!(c instanceof TextComponent)) {
                return false;
            }
            TextComponent text = (TextComponent)c;
            if (text.content().isBlank()) continue;
            return false;
        }
        return true;
    }
}

