/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.UUID;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.event.events.CarbonChatEventImpl;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.ChatMessagePacket;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public class MessagePacketHandler
implements Listener {
    @Inject
    public MessagePacketHandler(CarbonEventHandler events, @ServerId UUID serverId, Provider<MessagingManager> messaging) {
        events.subscribe(CarbonChatEvent.class, 100, false, event -> {
            CarbonChatEventImpl e;
            block6: {
                block5: {
                    if (!(event instanceof CarbonChatEventImpl)) break block5;
                    e = (CarbonChatEventImpl)event;
                    if (e.origin) break block6;
                }
                return;
            }
            if (event.sender() instanceof ConsoleCarbonPlayer) {
                return;
            }
            if (!event.chatChannel().shouldCrossServer()) {
                return;
            }
            ((MessagingManager)messaging.get()).queuePacket(() -> {
                CarbonPlayer sender = event.sender();
                Component networkMessage = e.renderFor(sender);
                return new ChatMessagePacket(serverId, sender.uuid(), event.chatChannel().key(), sender.username(), networkMessage);
            });
        });
    }
}

