/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.KeyedRenderer;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public class MuteHandler
implements Listener {
    private final Key muteKey = Key.key((String)"carbon", (String)"mute");
    private CarbonMessages carbonMessages;
    private final KeyedRenderer renderer = KeyedRenderer.keyedRenderer(this.muteKey, (sender, recipient, message, originalMessage) -> {
        Component prefix = this.carbonMessages.muteSpyPrefix(recipient);
        return prefix.append(message);
    });

    @Inject
    public MuteHandler(CarbonEventHandler events, CarbonMessages carbonMessages) {
        this.carbonMessages = carbonMessages;
        events.subscribe(CarbonChatEvent.class, 100, false, event -> {
            if (!event.sender().muted()) {
                return;
            }
            event.renderers().add(this.renderer);
            event.recipients().removeIf(entry -> {
                CarbonPlayer carbonPlayer;
                return entry instanceof CarbonPlayer && !(carbonPlayer = (CarbonPlayer)entry).spying() && !(entry instanceof ConsoleCarbonPlayer);
            });
        });
    }
}

