/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.Set;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.channels.PartyChatChannel;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

@DefaultQualifier(value=NonNull.class)
public class PartyChatSpyHandler
implements Listener {
    @Inject
    public PartyChatSpyHandler(CarbonEventHandler events, CarbonMessages messages, CarbonServer server) {
        events.subscribe(CarbonChatEvent.class, 100, false, event -> {
            if (!(event.chatChannel() instanceof PartyChatChannel)) {
                return;
            }
            @Nullable Party party = event.sender().party().get();
            Set<Object> members = party == null ? Set.of() : party.members();
            TextComponent partyName = party == null ? Component.empty() : party.name();
            for (CarbonPlayer carbonPlayer : server.players()) {
                if (!carbonPlayer.spying() || members.contains(carbonPlayer.uuid())) continue;
                messages.partySpy(carbonPlayer, event.sender().uuid(), event.sender().displayName(), event.sender().username(), event.message(), (Component)partyName);
            }
        });
    }
}

