/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.common.channels.PartyChatChannel;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.listeners.Listener;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.sound.Sound;

@DefaultQualifier(value=NonNull.class)
public class PartyPingHandler
implements Listener {
    @Inject
    public PartyPingHandler(CarbonEventHandler events, ConfigManager configManager) {
        events.subscribe(CarbonChatEvent.class, 100, false, event -> {
            if (!(event.chatChannel() instanceof PartyChatChannel)) {
                return;
            }
            @Nullable Sound sound = configManager.primaryConfig().partyChat().messageSound;
            if (configManager.primaryConfig().partyChat().playSound && sound != null) {
                for (Audience audience : event.recipients()) {
                    if (event.sender().uuid().equals(audience.get(Identity.UUID).orElse(null))) continue;
                    audience.playSound(sound);
                }
            }
        });
    }
}

