/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.regex.Pattern;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.KeyedRenderer;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.listeners.Listener;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

@DefaultQualifier(value=NonNull.class)
@Singleton
public class PingHandler
implements Listener {
    private final Key pingKey = Key.key((String)"carbon", (String)"pings");
    private final KeyedRenderer renderer;
    private final ConfigManager configManager;

    @Inject
    public PingHandler(CarbonEventHandler events, ConfigManager configManager) {
        this.configManager = configManager;
        this.renderer = KeyedRenderer.keyedRenderer(this.pingKey, (sender, recipient, message, originalMessage) -> {
            if (!(recipient instanceof CarbonPlayer)) {
                return message;
            }
            CarbonPlayer recipientPlayer = (CarbonPlayer)recipient;
            return this.convertPings(recipientPlayer, message);
        });
        events.subscribe(CarbonChatEvent.class, 1, false, event -> event.renderers().add(0, this.renderer));
    }

    public Component convertPings(CarbonPlayer recipient, Component message) {
        String prefix = this.configManager.primaryConfig().pings().prefix();
        String plainDisplayName = PlainTextComponentSerializer.plainText().serialize(recipient.displayName());
        return message.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(Pattern.compile(String.format("\\B%1$s(%2$s|%3$s)\\b", Pattern.quote(prefix), Pattern.quote(recipient.username()), Pattern.quote(plainDisplayName)), 2)).replacement(matchedText -> {
            if (this.configManager.primaryConfig().pings().playSound()) {
                recipient.playSound(this.configManager.primaryConfig().pings().sound());
            }
            return Component.text((String)matchedText.content()).color(this.configManager.primaryConfig().pings().highlightTextColor());
        }).build());
    }
}

