/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.ArrayList;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;

@DefaultQualifier(value=NonNull.class)
public class RadiusListener
implements Listener {
    @Inject
    public RadiusListener(CarbonEventHandler events, CarbonMessages carbonMessages) {
        events.subscribe(CarbonChatEvent.class, 0, false, event -> {
            if (event.chatChannel() == null) {
                return;
            }
            double radius = event.chatChannel().radius();
            if (radius < 0.0) {
                return;
            }
            ArrayList spyingPlayers = new ArrayList();
            if (radius == 0.0) {
                event.recipients().removeIf(audience -> {
                    if (audience.equals((Object)event.sender()) || audience instanceof ConsoleCarbonPlayer) {
                        return false;
                    }
                    if (audience instanceof CarbonPlayer) {
                        CarbonPlayer carbonPlayer = (CarbonPlayer)audience;
                        boolean sameWorld = carbonPlayer.sameWorldAs(event.sender());
                        if (!sameWorld && carbonPlayer.spying()) {
                            spyingPlayers.add(carbonPlayer);
                        }
                        return !sameWorld;
                    }
                    return false;
                });
            } else {
                event.recipients().removeIf(audience -> {
                    if (audience.equals((Object)event.sender()) || audience instanceof ConsoleCarbonPlayer) {
                        return false;
                    }
                    if (audience instanceof CarbonPlayer) {
                        boolean outOfRange;
                        CarbonPlayer carbonPlayer = (CarbonPlayer)audience;
                        if (!event.sender().sameWorldAs(carbonPlayer)) {
                            if (carbonPlayer.spying()) {
                                spyingPlayers.add(carbonPlayer);
                            }
                            return true;
                        }
                        double distance = carbonPlayer.distanceSquaredFrom(event.sender());
                        boolean bl = outOfRange = distance > radius * radius;
                        if (outOfRange && carbonPlayer.spying()) {
                            spyingPlayers.add(carbonPlayer);
                        }
                        return outOfRange;
                    }
                    return false;
                });
            }
            if (event.recipients().size() <= 2 && event.chatChannel().emptyRadiusRecipientsMessage()) {
                carbonMessages.emptyRecipients(event.sender());
                return;
            }
            for (CarbonPlayer player : spyingPlayers) {
                carbonMessages.radiusSpy(player, event.sender().uuid(), event.chatChannel().key(), event.sender().displayName(), event.sender().username(), event.message());
            }
        });
    }
}

