/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.net.kyori.moonshine.message.IMessageRenderer;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import net.draycia.carbon.common.messages.RenderForTagResolver;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@DefaultQualifier(value=NonNull.class)
public abstract class CarbonMessageRenderer
implements IMessageRenderer<Audience, String, Component, Object> {
    private final RenderForTagResolver.Factory renderForTagResolver;

    protected CarbonMessageRenderer(RenderForTagResolver.Factory renderForTagResolver) {
        this.renderForTagResolver = renderForTagResolver;
    }

    public final IMessageRenderer<SourcedAudience, String, Component, Object> asSourced() {
        return this::render;
    }

    @Override
    public final Component render(Audience receiver, String intermediateMessage, Map<String, ?> resolvedPlaceholders, @Nullable Method method, @Nullable Type owner) {
        TagResolver.Builder builder = TagResolver.builder();
        CarbonMessageRenderer.addResolved(builder, resolvedPlaceholders);
        builder.resolver((TagResolver)this.renderForTagResolver.create(resolvedPlaceholders));
        return this.render(receiver, intermediateMessage, builder);
    }

    protected abstract Component render(Audience var1, String var2, TagResolver.Builder var3);

    private static void addResolved(TagResolver.Builder tagResolver, Map<String, ?> resolvedPlaceholders) {
        for (Map.Entry<String, ?> entry : resolvedPlaceholders.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof Tag) {
                Tag tag = (Tag)obj;
                tagResolver.tag(entry.getKey(), tag);
                continue;
            }
            obj = entry.getValue();
            if (obj instanceof TagResolver) {
                TagResolver resolver = (TagResolver)obj;
                tagResolver.resolver(resolver);
                continue;
            }
            throw new IllegalArgumentException(entry.getValue().toString());
        }
    }
}

