/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.net.kyori.moonshine.message.IMessageSource;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.event.events.CarbonReloadEvent;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.translation.Translator;
import org.apache.logging.log4j.Logger;

@Singleton
@DefaultQualifier(value=NonNull.class)
public final class CarbonMessageSource
implements IMessageSource<Audience, String> {
    private final Locale defaultLocale;
    private volatile Map<Locale, Properties> locales = Map.of();
    private final Path pluginJar;
    private final Logger logger;
    private final Path dataDirectory;

    @Inject
    private CarbonMessageSource(CarbonEventHandler events, @DataDirectory Path dataDirectory, ConfigManager configManager, Logger logger) throws IOException {
        this.dataDirectory = dataDirectory;
        this.pluginJar = CarbonMessageSource.pluginJar();
        this.logger = logger;
        this.defaultLocale = configManager.primaryConfig().defaultLocale();
        this.reloadTranslations();
        events.subscribe(CarbonReloadEvent.class, -99, true, event -> this.reloadTranslations());
    }

    private static @NonNull Path pluginJar() {
        try {
            int exclamationIdx;
            URL sourceUrl = CarbonMessageSource.class.getProtectionDomain().getCodeSource().getLocation();
            if (sourceUrl.getProtocol().equals("jar") && (exclamationIdx = sourceUrl.getPath().lastIndexOf(33)) != -1) {
                sourceUrl = URI.create(sourceUrl.getPath().substring(0, exclamationIdx)).toURL();
            }
            return Paths.get(sourceUrl.toURI());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new RuntimeException("Could not locate plugin jar", ex);
        }
    }

    private void reloadTranslations() throws IOException {
        HashMap map = new HashMap();
        Path localeDirectory = this.dataDirectory.resolve("locale");
        if (!Files.exists(localeDirectory, new LinkOption[0])) {
            Files.createDirectories(localeDirectory, new FileAttribute[0]);
        }
        this.walkPluginJar(stream -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> {
            String pathString = it.toString();
            return pathString.startsWith("/locale/messages-") && pathString.endsWith(".properties");
        }).forEach(localeFile -> {
            String localeString = CarbonMessageSource.localeString(localeFile);
            @Nullable Locale locale = CarbonMessageSource.parseLocale(localeString);
            if (locale == null) {
                this.logger.warn("Unknown locale '{}'?", (Object)localeString);
                return;
            }
            this.tryLoadLocale(map, localeDirectory, (Path)localeFile, locale);
        }));
        try (Stream<Path> paths = Files.list(localeDirectory);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(localeFile -> {
                String localeString = CarbonMessageSource.localeString(localeFile);
                @Nullable Locale locale = CarbonMessageSource.parseLocale(localeString);
                if (locale == null) {
                    this.logger.warn("Unknown locale '{}'?", (Object)localeString);
                    return;
                }
                if (map.containsKey(locale)) {
                    return;
                }
                this.tryLoadLocale(map, localeDirectory, (Path)localeFile, locale);
            });
        }
        this.logger.info("Loaded {} locales: [{}]", (Object)map.size(), (Object)map.keySet().stream().map(Locale::toString).collect(Collectors.joining(", ")));
        this.locales = Map.copyOf(map);
    }

    private void tryLoadLocale(Map<Locale, Properties> map, Path localeDirectory, Path localeFile, Locale locale) {
        @Nullable Properties properties = this.readLocale(localeDirectory, localeFile, locale);
        if (properties != null) {
            map.put(locale, properties);
        }
    }

    private @Nullable Properties readLocale(Path localeDirectory, Path localeFile, Locale locale) {
        this.logger.debug("Found locale {} ({}) in: {}", (Object)locale.getDisplayName(), (Object)locale, (Object)localeFile);
        Properties properties = new Properties(){

            @Override
            public synchronized Set<Map.Entry<Object, Object>> entrySet() {
                return Collections.unmodifiableSet(super.entrySet().stream().sorted(Comparator.comparing(entry -> entry.getKey().toString())).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        };
        try {
            this.loadProperties(properties, localeDirectory, localeFile);
            this.logger.debug("Successfully loaded locale {} ({})", (Object)locale.getDisplayName(), (Object)locale);
            return properties;
        }
        catch (IOException ex) {
            this.logger.warn("Unable to load locale {} ({}) from source: {}", (Object)locale.getDisplayName(), (Object)locale, (Object)localeFile, (Object)ex);
            return null;
        }
    }

    @Override
    public String messageOf(Audience receiver, String messageKey) {
        Audience audience = receiver;
        if (audience instanceof SourcedAudience) {
            SourcedAudience sourced = (SourcedAudience)audience;
            audience = sourced.recipient();
        }
        if (audience instanceof PlayerCommander) {
            PlayerCommander playerCommander = (PlayerCommander)audience;
            audience = playerCommander.carbonPlayer();
        }
        if (audience instanceof CarbonPlayer) {
            CarbonPlayer player = (CarbonPlayer)audience;
            return this.forPlayer(messageKey, player);
        }
        return this.fromDefaultLocale(messageKey);
    }

    private String forPlayer(String key, CarbonPlayer player) {
        String message;
        Properties properties;
        @Nullable Locale locale = player.locale();
        if (locale != null && (properties = this.locales.get(locale)) != null && (message = properties.getProperty(key)) != null) {
            return CarbonMessageSource.fixCrowdin(message);
        }
        return this.fromDefaultLocale(key);
    }

    private String fromDefaultLocale(String key) {
        Properties defaultProperties = this.locales.get(this.defaultLocale);
        if (defaultProperties != null) {
            String value = defaultProperties.getProperty(key);
            if (value == null) {
                this.logger.warn("No message mapping for key " + key + " in default locale " + this.defaultLocale.getDisplayName());
                return key;
            }
            return CarbonMessageSource.fixCrowdin(value);
        }
        return key;
    }

    private void walkPluginJar(Consumer<Stream<Path>> user) throws IOException {
        if (Files.isDirectory(this.pluginJar, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(this.pluginJar, new FileVisitOption[0]);){
                user.accept(stream.map(path -> path.relativize(this.pluginJar)));
            }
            return;
        }
        try (FileSystem jar = FileSystems.newFileSystem(this.pluginJar, this.getClass().getClassLoader());){
            Path root = jar.getRootDirectories().iterator().next();
            try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                user.accept(stream);
            }
        }
    }

    private void loadProperties(Properties properties, Path localeDirectory, Path sourceFile) throws IOException {
        InputStreamReader reader;
        Path userFile = localeDirectory.resolve(sourceFile.getFileName().toString());
        boolean samePath = sourceFile.normalize().toAbsolutePath().equals(userFile.normalize().toAbsolutePath());
        if (Files.isRegularFile(userFile, new LinkOption[0])) {
            InputStream inputStream = Files.newInputStream(userFile, new OpenOption[0]);
            reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            try {
                properties.load(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        } else if (samePath && !Files.isRegularFile(userFile, new LinkOption[0])) {
            throw new IllegalStateException("sourceFile == userFile, and is not a regular file (%s)".formatted(userFile));
        }
        boolean write = false;
        if (Files.isRegularFile(sourceFile, new LinkOption[0]) && !samePath) {
            reader = new InputStreamReader(Files.newInputStream(sourceFile, new OpenOption[0]), StandardCharsets.UTF_8);
            try {
                Properties packaged = new Properties();
                packaged.load(reader);
                for (Map.Entry<Object, Object> entry : packaged.entrySet()) {
                    write |= properties.putIfAbsent(entry.getKey(), entry.getValue()) == null;
                }
            }
            finally {
                ((Reader)reader).close();
            }
        }
        if (write) {
            try (BufferedWriter outputStream = Files.newBufferedWriter(userFile, new OpenOption[0]);){
                properties.store(outputStream, null);
            }
        }
    }

    private static String localeString(Path localeFile) {
        return localeFile.getFileName().toString().substring("messages-".length()).replace(".properties", "");
    }

    private static @Nullable Locale parseLocale(String localeString) {
        localeString = localeString.replace("nb_NO", "no_NO");
        return Translator.parseLocale((String)localeString);
    }

    private static String fixCrowdin(String s) {
        return s.replace("''", "'");
    }
}

