/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import java.util.Iterator;

public final class PrefixedDelegateIterator<T>
implements Iterator<T> {
    private final T prefix;
    private final Iterator<T> delegate;
    private boolean seenPrefix = false;

    public PrefixedDelegateIterator(T prefix, Iterator<T> delegate) {
        this.prefix = prefix;
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return !this.seenPrefix || this.delegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.seenPrefix) {
            this.seenPrefix = true;
            return this.prefix;
        }
        return this.delegate.next();
    }

    @Override
    public void remove() {
        if (!this.seenPrefix) {
            throw new IllegalStateException("must see prefix before removing from iterator");
        }
        this.delegate.remove();
    }
}

