/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@DefaultQualifier(value=NonNull.class)
public final class RenderForTagResolver
implements TagResolver {
    private static final String TAG_NAME = "render_for";
    private final UserManagerInternal<?> users;
    private final ProfileResolver profileResolver;
    private final Provider<CarbonMessageRenderer> messageRenderer;
    private final Map<String, ?> resolvedPlaceholders;

    @AssistedInject
    private RenderForTagResolver(UserManagerInternal<?> users, ProfileResolver profileResolver, Provider<CarbonMessageRenderer> messageRenderer, @Assisted Map<String, ?> resolvedPlaceholders) {
        this.users = users;
        this.profileResolver = profileResolver;
        this.messageRenderer = messageRenderer;
        this.resolvedPlaceholders = resolvedPlaceholders;
    }

    public @Nullable Tag resolve(String name, ArgumentQueue arguments, Context ctx) throws ParsingException {
        CarbonPlayer player;
        CompletionStage<Object> playerFuture;
        if (!this.has(name)) {
            return null;
        }
        String renderFor = arguments.popOr("Missing username or UUID to render for").value();
        try {
            UUID uuid2 = UUID.fromString(renderFor);
            playerFuture = this.users.user(uuid2);
        }
        catch (IllegalArgumentException ignore) {
            playerFuture = this.profileResolver.resolveUUID(renderFor).thenCompose(uuid -> {
                if (uuid != null) {
                    return this.users.user((UUID)uuid);
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        try {
            player = (CarbonPlayer)((CompletableFuture)playerFuture).join();
            if (player == null) {
                return null;
            }
        }
        catch (CancellationException | CompletionException ignore) {
            return null;
        }
        String value = arguments.popOr("Missing message value").value();
        if (value.equalsIgnoreCase("inserting")) {
            return Tag.inserting((Component)((CarbonMessageRenderer)this.messageRenderer.get()).render((Audience)SourcedAudience.of(player, player), arguments.popOr("Missing message value").value(), this.resolvedPlaceholders, (Method)null, (Type)null));
        }
        if (value.equalsIgnoreCase("self_closing_inserting")) {
            return Tag.selfClosingInserting((Component)((CarbonMessageRenderer)this.messageRenderer.get()).render((Audience)SourcedAudience.of(player, player), arguments.popOr("Missing message value").value(), this.resolvedPlaceholders, (Method)null, (Type)null));
        }
        return Tag.selfClosingInserting((Component)((CarbonMessageRenderer)this.messageRenderer.get()).render((Audience)SourcedAudience.of(player, player), value, this.resolvedPlaceholders, (Method)null, (Type)null));
    }

    public boolean has(String name) {
        return name.equalsIgnoreCase(TAG_NAME);
    }

    public static interface Factory {
        public RenderForTagResolver create(Map<String, ?> var1);
    }
}

