/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocator;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocatorResolver;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.kyori.adventure.audience.Audience;

@Singleton
@DefaultQualifier(value=NonNull.class)
public final class SourcedReceiverResolver
implements IReceiverLocatorResolver<SourcedAudience> {
    @Override
    public IReceiverLocator<SourcedAudience> resolve(Method method, Type proxy) {
        return new Resolver();
    }

    private static final class Resolver
    implements IReceiverLocator<SourcedAudience> {
        private Resolver() {
        }

        @Override
        public SourcedAudience locate(Method method, Object proxy, @Nullable Object[] parameters) {
            if (parameters.length == 0) {
                return SourcedAudience.empty();
            }
            Object parameter = parameters[0];
            if (parameter instanceof SourcedAudience) {
                SourcedAudience sourcedAudience = (SourcedAudience)parameter;
                return sourcedAudience;
            }
            if (parameter instanceof Audience) {
                Audience audience = (Audience)parameter;
                return SourcedAudience.of(audience, audience);
            }
            return SourcedAudience.empty();
        }
    }
}

