/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.annotation.Placeholder;
import carbonchat.libs.net.kyori.moonshine.exception.PlaceholderResolvingException;
import carbonchat.libs.net.kyori.moonshine.exception.UnfinishedPlaceholderException;
import carbonchat.libs.net.kyori.moonshine.model.MoonshineMethod;
import carbonchat.libs.net.kyori.moonshine.placeholder.ContinuanceValue;
import carbonchat.libs.net.kyori.moonshine.placeholder.IPlaceholderResolver;
import carbonchat.libs.net.kyori.moonshine.strategy.IPlaceholderResolverStrategy;
import carbonchat.libs.net.kyori.moonshine.strategy.supertype.ISupertypeStrategy;
import carbonchat.libs.net.kyori.moonshine.strategy.supertype.StandardSupertypeThenInterfaceSupertypeStrategy;
import carbonchat.libs.net.kyori.moonshine.util.Weighted;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.spongepowered.configurate.util.NamingScheme;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import net.draycia.carbon.common.messages.NotPlaceholder;
import net.draycia.carbon.common.messages.PrefixedDelegateIterator;
import net.kyori.adventure.audience.Audience;

public final class StandardPlaceholderResolverStrategyButDifferent<R, I, F>
implements IPlaceholderResolverStrategy<R, I, F> {
    private final ISupertypeStrategy supertypeStrategy = new StandardSupertypeThenInterfaceSupertypeStrategy(false);
    private final NamingScheme namingScheme;

    public StandardPlaceholderResolverStrategyButDifferent(NamingScheme placeholderParamaterDefaultNamingScheme) {
        this.namingScheme = placeholderParamaterDefaultNamingScheme;
    }

    @Override
    public Map<String, ? extends F> resolvePlaceholders(Moonshine<R, I, ?, F> moonshine, R receiver, I intermediateText, MoonshineMethod<? extends R> moonshineMethod, @Nullable Object[] parameters) throws PlaceholderResolvingException {
        int start;
        if (parameters.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap finalisedPlaceholders = new LinkedHashMap(parameters.length);
        LinkedHashMap resolvingPlaceholders = new LinkedHashMap(16);
        Parameter[] methodParameters = moonshineMethod.reflectMethod().getParameters();
        Type[] exactParameterTypes = GenericTypeReflector.getParameterTypes((Executable)moonshineMethod.reflectMethod(), (Type)moonshine.proxiedType());
        for (int idx = start = moonshineMethod.reflectMethod().getReturnType() != Void.TYPE ? 0 : 1; idx < parameters.length; ++idx) {
            Parameter parameter = methodParameters[idx];
            Object value = parameters[idx];
            if (value == null || parameter.getType() == Audience.class || parameter.getAnnotation(NotPlaceholder.class) != null) continue;
            Type parameterType = GenericTypeReflector.getExactSubType((Type)exactParameterTypes[idx], value.getClass());
            @Nullable Placeholder placeholder = parameter.getAnnotation(Placeholder.class);
            String placeholderName = placeholder != null && !placeholder.value().isEmpty() ? placeholder.value() : this.namingScheme.coerce(parameter.getName());
            resolvingPlaceholders.put(placeholderName, ContinuanceValue.continuanceValue(value, parameterType));
        }
        this.resolvePlaceholder(moonshine, receiver, finalisedPlaceholders, resolvingPlaceholders, moonshineMethod, parameters);
        return finalisedPlaceholders;
    }

    private void resolvePlaceholder(Moonshine<R, I, ?, F> moonshine, R receiver, Map<String, F> finalisedPlaceholders, Map<String, ContinuanceValue<?>> resolvingPlaceholders, MoonshineMethod<? extends R> moonshineMethod, @Nullable Object[] parameters) throws UnfinishedPlaceholderException {
        Map<Type, NavigableSet<Weighted<IPlaceholderResolver<R, ?, F>>>> weightedPlaceholderResolvers = moonshine.weightedPlaceholderResolvers();
        block0: while (!resolvingPlaceholders.isEmpty()) {
            Iterator<Map.Entry<String, ContinuanceValue<?>>> resolvingPlaceholderIterator = resolvingPlaceholders.entrySet().iterator();
            if (!resolvingPlaceholderIterator.hasNext()) continue;
            Map.Entry<String, ContinuanceValue<?>> continuanceEntry = resolvingPlaceholderIterator.next();
            String continuancePlaceholderName = continuanceEntry.getKey();
            Type type = continuanceEntry.getValue().type();
            Object value = continuanceEntry.getValue().value();
            PrefixedDelegateIterator<Type> hierarchyIterator = new PrefixedDelegateIterator<Type>(type, this.supertypeStrategy.hierarchyIterator(type));
            while (hierarchyIterator.hasNext()) {
                Type supertype = (Type)hierarchyIterator.next();
                for (Weighted weighted : weightedPlaceholderResolvers.getOrDefault(supertype, Collections.emptyNavigableSet())) {
                    IPlaceholderResolver placeholderResolver = (IPlaceholderResolver)weighted.value();
                    Map resolverResult = placeholderResolver.resolve(continuancePlaceholderName, value, receiver, moonshineMethod.owner().getType(), moonshineMethod.reflectMethod(), parameters);
                    if (resolverResult == null) continue;
                    resolvingPlaceholderIterator.remove();
                    resolverResult.forEach((resolvedName, resolvedValue) -> resolvedValue.map(conclusionValue -> finalisedPlaceholders.put((String)resolvedName, conclusionValue.value()), continuanceValue -> resolvingPlaceholders.put((String)resolvedName, (ContinuanceValue<?>)continuanceValue)));
                    continue block0;
                }
            }
            throw new UnfinishedPlaceholderException(moonshineMethod, continuancePlaceholderName, value);
        }
    }
}

