/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messages;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.Map;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;

@DefaultQualifier(value=NonNull.class)
public final class TagPermissions {
    public static final String NICKNAME = "carbon.nickname.tags";
    public static final String MESSAGE = "carbon.messagetags";
    public static final String PARTY_NAME = "carbon.parties.name.tags";
    private static final Map<String, TagResolver> DEFAULT_TAGS = Map.ofEntries(Map.entry("hover", StandardTags.hoverEvent()), Map.entry("click", StandardTags.clickEvent()), Map.entry("color", StandardTags.color()), Map.entry("keybind", StandardTags.keybind()), Map.entry("translatable", StandardTags.translatable()), Map.entry("insertion", StandardTags.insertion()), Map.entry("font", StandardTags.font()), Map.entry("decorations", StandardTags.decorations()), Map.entry("gradient", StandardTags.gradient()), Map.entry("rainbow", StandardTags.rainbow()), Map.entry("reset", StandardTags.reset()), Map.entry("newline", StandardTags.newline()), Map.entry("pride", StandardTags.pride()), Map.entry("shadow_color", StandardTags.shadowColor()), Map.entry("transition", StandardTags.transition()));

    private TagPermissions() {
    }

    public static Component parseTags(@Nullable Audience audience, String basePermission, String message, Predicate<String> permission, TagResolver.Builder resolver) {
        boolean hasAllDecorations = false;
        for (Map.Entry<String, TagResolver> entry : DEFAULT_TAGS.entrySet()) {
            if (!permission.test(basePermission + "." + entry.getKey())) continue;
            resolver.resolver(entry.getValue());
            if (!entry.getKey().equals("decorations")) continue;
            hasAllDecorations = true;
        }
        if (!hasAllDecorations) {
            for (TextDecoration decoration : TextDecoration.values()) {
                if (!permission.test(basePermission + "." + decoration.name())) continue;
                resolver.resolver(StandardTags.decorations((TextDecoration)decoration));
            }
        }
        MiniMessage miniMessage = MiniMessage.builder().tags(resolver.build()).build();
        if (audience != null) {
            return miniMessage.deserialize(message, (Pointered)audience);
        }
        return miniMessage.deserialize((Object)message);
    }

    public static Component parseTags(@Nullable Audience audience, String basePermission, String message, Predicate<String> permission) {
        return TagPermissions.parseTags(audience, basePermission, message, permission, TagResolver.builder());
    }
}

