/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging;

import carbonchat.libs.ninja.egg82.messenger.handler.AbstractMessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.ArrayList;
import java.util.List;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.KeyedRenderer;
import net.draycia.carbon.common.command.commands.WhisperCommand;
import net.draycia.carbon.common.event.events.CarbonChatEventImpl;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.ChatMessagePacket;
import net.draycia.carbon.common.messaging.packets.DisbandPartyPacket;
import net.draycia.carbon.common.messaging.packets.InvalidatePartyInvitePacket;
import net.draycia.carbon.common.messaging.packets.LocalPlayerChangePacket;
import net.draycia.carbon.common.messaging.packets.LocalPlayersPacket;
import net.draycia.carbon.common.messaging.packets.PartyChangePacket;
import net.draycia.carbon.common.messaging.packets.PartyInvitePacket;
import net.draycia.carbon.common.messaging.packets.SaveCompletedPacket;
import net.draycia.carbon.common.messaging.packets.WhisperPacket;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.draycia.carbon.common.users.NetworkUsers;
import net.draycia.carbon.common.users.PartyInvites;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;

@DefaultQualifier(value=NonNull.class)
public final class CarbonChatPacketHandler
extends AbstractMessagingHandler {
    private final CarbonEventHandler events;
    private final CarbonServer server;
    private final ChannelRegistry channels;
    private final UserManagerInternal<?> userManager;
    private final NetworkUsers networkUsers;
    private final WhisperCommand.WhisperHandler whisper;
    private final PartyInvites partyInvites;

    CarbonChatPacketHandler(CarbonChat carbonChat, MessagingManager messagingManager, UserManagerInternal<?> userManager, NetworkUsers networkUsers, WhisperCommand.WhisperHandler whisper, PartyInvites partyInvites) {
        super(messagingManager.requirePacketService());
        this.events = carbonChat.eventHandler();
        this.server = carbonChat.server();
        this.channels = carbonChat.channelRegistry();
        this.userManager = userManager;
        this.networkUsers = networkUsers;
        this.whisper = whisper;
        this.partyInvites = partyInvites;
    }

    @Override
    protected boolean handlePacket(Packet packet) {
        if (packet instanceof SaveCompletedPacket) {
            SaveCompletedPacket statePacket = (SaveCompletedPacket)packet;
            this.userManager.saveCompleteMessageReceived(statePacket.playerId());
            return true;
        }
        if (packet instanceof PartyChangePacket) {
            PartyChangePacket pkt = (PartyChangePacket)packet;
            this.userManager.partyChangeMessageReceived(pkt);
            return true;
        }
        if (packet instanceof PartyInvitePacket) {
            PartyInvitePacket pkt = (PartyInvitePacket)packet;
            this.partyInvites.handle(pkt);
            return true;
        }
        if (packet instanceof InvalidatePartyInvitePacket) {
            InvalidatePartyInvitePacket pkt = (InvalidatePartyInvitePacket)packet;
            this.partyInvites.handle(pkt);
            return true;
        }
        if (packet instanceof DisbandPartyPacket) {
            DisbandPartyPacket pkt = (DisbandPartyPacket)packet;
            this.userManager.disbandPartyMessageReceived(pkt);
            return true;
        }
        if (packet instanceof ChatMessagePacket) {
            ChatMessagePacket messagePacket = (ChatMessagePacket)packet;
            this.handleMessagePacket(messagePacket);
            return true;
        }
        if (packet instanceof LocalPlayersPacket) {
            LocalPlayersPacket playersPacket = (LocalPlayersPacket)packet;
            this.networkUsers.handlePacket(playersPacket);
            return true;
        }
        if (packet instanceof LocalPlayerChangePacket) {
            LocalPlayerChangePacket playerChangePacket = (LocalPlayerChangePacket)packet;
            this.networkUsers.handlePacket(playerChangePacket);
            return true;
        }
        if (packet instanceof WhisperPacket) {
            WhisperPacket whisperPacket = (WhisperPacket)packet;
            this.whisper.handlePacket(whisperPacket);
            return true;
        }
        return false;
    }

    private boolean handleMessagePacket(ChatMessagePacket messagePacket) {
        CarbonPlayer sender = (CarbonPlayer)this.userManager.user(messagePacket.userId()).join();
        @Nullable ChatChannel channel = this.channels.channel(messagePacket.channelKey());
        if (channel == null) {
            return false;
        }
        if (!channel.shouldCrossServer()) {
            return false;
        }
        ArrayList<KeyedRenderer> renderers = new ArrayList<KeyedRenderer>();
        List<Audience> recipients = channel.recipients(sender);
        CarbonChatEventImpl chatEvent = new CarbonChatEventImpl(sender, messagePacket.message(), recipients, renderers, channel, null, false);
        this.events.emit(chatEvent);
        renderers.add(KeyedRenderer.keyedRenderer(Key.key((String)"carbon", (String)"console_cs"), ($, recipient, message, original) -> {
            if (recipient instanceof ConsoleCarbonPlayer) {
                return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)"[Cross-Server] "), message});
            }
            return message;
        }));
        for (Audience recipient2 : recipients) {
            CarbonPlayer carbonRecipient;
            if (recipient2 instanceof CarbonPlayer && !(carbonRecipient = (CarbonPlayer)recipient2).hasPermission("carbon.crossserver")) continue;
            recipient2.sendMessage(chatEvent.renderFor(recipient2));
        }
        return true;
    }
}

