/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.ninja.egg82.messenger.MessagingService;
import carbonchat.libs.ninja.egg82.messenger.NATSMessagingService;
import carbonchat.libs.ninja.egg82.messenger.PacketManager;
import carbonchat.libs.ninja.egg82.messenger.RabbitMQMessagingService;
import carbonchat.libs.ninja.egg82.messenger.RedisMessagingService;
import carbonchat.libs.ninja.egg82.messenger.handler.AbstractServerMessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandlerImpl;
import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.MultiPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.InitializationPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.KeepAlivePacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionRequestPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.ShutdownPacket;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.CarbonChatInternal;
import net.draycia.carbon.common.command.commands.WhisperCommand;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.config.MessagingSettings;
import net.draycia.carbon.common.messaging.CarbonChatPacketHandler;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.ChatMessagePacket;
import net.draycia.carbon.common.messaging.packets.DisbandPartyPacket;
import net.draycia.carbon.common.messaging.packets.InvalidatePartyInvitePacket;
import net.draycia.carbon.common.messaging.packets.LocalPlayerChangePacket;
import net.draycia.carbon.common.messaging.packets.LocalPlayersPacket;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.messaging.packets.PartyChangePacket;
import net.draycia.carbon.common.messaging.packets.PartyInvitePacket;
import net.draycia.carbon.common.messaging.packets.SaveCompletedPacket;
import net.draycia.carbon.common.messaging.packets.WhisperPacket;
import net.draycia.carbon.common.users.NetworkUsers;
import net.draycia.carbon.common.users.PartyInvites;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.util.ConcurrentUtil;
import net.draycia.carbon.common.util.ExceptionLoggingScheduledThreadPoolExecutor;
import net.draycia.carbon.common.util.Exceptions;
import org.apache.logging.log4j.Logger;

@Singleton
@DefaultQualifier(value=NonNull.class)
public class MessagingManager {
    private static final byte protocolVersion = 1;
    private final Logger logger;
    private final UUID serverId;
    private final @MonotonicNonNull ScheduledExecutorService scheduledExecutor;
    private final @MonotonicNonNull MessagingService messagingService;
    private volatile @MonotonicNonNull PacketService packetService;

    @Inject
    public MessagingManager(ConfigManager configManager, CarbonChat carbonChat, @ServerId UUID serverId, CarbonServer server, Logger logger, UserManagerInternal<?> userManager, NetworkUsers networkUsers, WhisperCommand.WhisperHandler whisper, PacketFactory packetFactory, PartyInvites partyInvites) {
        this.serverId = serverId;
        this.logger = logger;
        boolean proxy = ((CarbonChatInternal)carbonChat).isProxy();
        if (proxy || !configManager.primaryConfig().messagingSettings().enabled()) {
            if (!proxy) {
                logger.info("Messaging services disabled in config. Cross-server will not work without this!");
            } else if (configManager.primaryConfig().messagingSettings().enabled()) {
                logger.warn("Messaging services enabled in config, but messaging is not supported on proxies. The messaging service is used for the configuration where Carbon is installed on all backends instead of the proxy.");
            }
            this.messagingService = null;
            this.packetService = null;
            this.scheduledExecutor = null;
            return;
        }
        PacketManager.register(MultiPacket.class, MultiPacket::new);
        PacketManager.register(KeepAlivePacket.class, KeepAlivePacket::new);
        PacketManager.register(InitializationPacket.class, InitializationPacket::new);
        PacketManager.register(PacketVersionPacket.class, PacketVersionPacket::new);
        PacketManager.register(PacketVersionRequestPacket.class, PacketVersionRequestPacket::new);
        PacketManager.register(ShutdownPacket.class, ShutdownPacket::new);
        PacketManager.register(ChatMessagePacket.class, ChatMessagePacket::new);
        PacketManager.register(SaveCompletedPacket.class, SaveCompletedPacket::new);
        PacketManager.register(LocalPlayersPacket.class, LocalPlayersPacket::new);
        PacketManager.register(LocalPlayerChangePacket.class, LocalPlayerChangePacket::new);
        PacketManager.register(WhisperPacket.class, WhisperPacket::new);
        PacketManager.register(PartyChangePacket.class, PartyChangePacket::new);
        PacketManager.register(PartyInvitePacket.class, PartyInvitePacket::new);
        PacketManager.register(InvalidatePartyInvitePacket.class, InvalidatePartyInvitePacket::new);
        PacketManager.register(DisbandPartyPacket.class, DisbandPartyPacket::new);
        this.packetService = new PacketService(4, false, 1);
        this.scheduledExecutor = new ExceptionLoggingScheduledThreadPoolExecutor(4, ConcurrentUtil.carbonThreadFactory(logger, "MessagingManager"), logger);
        MessagingHandlerImpl handlerImpl = new MessagingHandlerImpl(this.packetService);
        handlerImpl.addHandler(new CarbonServerHandler(server, serverId, this.packetService, handlerImpl, packetFactory));
        handlerImpl.addHandler(new CarbonChatPacketHandler(carbonChat, this, userManager, networkUsers, whisper, partyInvites));
        try {
            this.messagingService = this.initMessagingService(this.packetService, handlerImpl, new File("/"), configManager.primaryConfig().messagingSettings());
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw Exceptions.rethrow(e);
        }
        this.packetService.addMessenger(this.messagingService);
        this.packetService.queuePacket(new InitializationPacket(serverId, 1));
        this.packetService.flushQueue();
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            this.packetService.queuePacket(new KeepAlivePacket(serverId));
            this.packetService.flushQueue();
        }, 5L, 5L, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.packetService.flushQueue();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public PacketService requirePacketService() {
        return Objects.requireNonNull(this.packetService, "packetService");
    }

    private void withPacketService(Consumer<PacketService> consumer) {
        if (this.packetService != null) {
            consumer.accept(this.packetService);
        }
    }

    public void queuePacketAndFlush(Supplier<? extends AbstractPacket> makePacket) {
        this.withPacketService(service -> {
            service.queuePacket((Packet)makePacket.get());
            service.flushQueue();
        });
    }

    public void queuePacket(Supplier<? extends AbstractPacket> makePacket) {
        this.withPacketService(service -> service.queuePacket((Packet)makePacket.get()));
    }

    public void onShutdown() {
        if (this.scheduledExecutor != null) {
            ConcurrentUtil.shutdownExecutor(this.scheduledExecutor, TimeUnit.MILLISECONDS, 500L);
        }
        if (this.packetService != null) {
            this.packetService.flushQueue();
            this.packetService.shutdown();
            this.packetService = null;
        }
        if (this.messagingService != null) {
            this.messagingService.close();
        }
    }

    private MessagingService initMessagingService(PacketService packetService, MessagingHandlerImpl handlerImpl, File packetDir, MessagingSettings messagingSettings) throws IOException, TimeoutException, InterruptedException {
        String name = "engine1";
        String channelName = "carbon-data";
        return switch (messagingSettings.brokerType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                this.logger.info("Initializing RabbitMQ Messaging services...");
                RabbitMQMessagingService.Builder builder = RabbitMQMessagingService.builder(packetService, "engine1", "carbon-data", this.serverId, handlerImpl, 0L, false, packetDir).url(messagingSettings.url(), messagingSettings.port(), messagingSettings.vhost()).timeout(5000);
                if (messagingSettings.username() != null && !messagingSettings.username().isBlank()) {
                    builder.credentials(messagingSettings.username(), messagingSettings.password());
                }
                yield builder.build();
            }
            case 2 -> {
                this.logger.info("Initializing NATS Messaging services...");
                NATSMessagingService.Builder builder = NATSMessagingService.builder(packetService, "engine1", "carbon-data", this.serverId, handlerImpl, 0L, false, packetDir).url(messagingSettings.url(), messagingSettings.port()).life(5000);
                if (messagingSettings.credentialsFile() != null && !messagingSettings.credentialsFile().isBlank()) {
                    builder.credentials(messagingSettings.credentialsFile());
                }
                yield builder.build();
            }
            case 3 -> {
                this.logger.info("Initializing Redis Messaging services...");
                RedisMessagingService.Builder builder = RedisMessagingService.builder(packetService, "engine1", "carbon-data", this.serverId, handlerImpl, 0L, false, packetDir).url(messagingSettings.url(), messagingSettings.port());
                if (messagingSettings.password() != null && !messagingSettings.password().isBlank()) {
                    builder.credentials(messagingSettings.password());
                }
                yield builder.build();
            }
            case 0 -> throw new IllegalStateException("MessagingManager initialized with no messaging broker selected!");
        };
    }

    private static final class CarbonServerHandler
    extends AbstractServerMessagingHandler {
        private final CarbonServer server;
        private final PacketFactory packetFactory;

        private CarbonServerHandler(@NonNull CarbonServer server, @NonNull UUID serverId, @NonNull PacketService packetService, @NonNull MessagingHandler messagingHandler, @NonNull PacketFactory packetFactory) {
            super(serverId, packetService, messagingHandler);
            this.server = server;
            this.packetFactory = packetFactory;
        }

        @Override
        protected void handleInitialization(@NonNull InitializationPacket packet) {
            super.handleInitialization(packet);
            List<? extends CarbonPlayer> players = this.server.players();
            HashMap<UUID, String> map = new HashMap<UUID, String>();
            for (CarbonPlayer carbonPlayer : players) {
                map.put(carbonPlayer.uuid(), carbonPlayer.username());
            }
            this.packetService.queuePacket(this.packetFactory.localPlayersPacket(map));
        }
    }

    public static enum BrokerType {
        NONE,
        RABBITMQ,
        NATS,
        REDIS;

    }
}

