/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class CarbonPacket
extends AbstractPacket {
    private final GsonComponentSerializer componentSerializer = GsonComponentSerializer.gson();

    protected CarbonPacket(@NotNull UUID sender) {
        super(sender);
    }

    protected final void writeComponent(Component component, ByteBuf buffer) {
        this.writeString((String)this.componentSerializer.serialize(component), buffer);
    }

    protected final Component readComponent(ByteBuf buffer) {
        return this.componentSerializer.deserialize((Object)this.readString(buffer));
    }

    protected final void writeKey(Key key, ByteBuf buffer) {
        this.writeString(key.asString(), buffer);
    }

    protected final Key readKey(ByteBuf buffer) {
        String value = this.readString(buffer);
        return Key.key((String)value);
    }

    protected final <K, V> void writeMap(Map<K, V> map, BiConsumer<K, ByteBuf> keyWriter, BiConsumer<V, ByteBuf> valueWriter, ByteBuf buffer) {
        this.writeVarInt(map.size(), buffer);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.accept(entry.getKey(), buffer);
            valueWriter.accept(entry.getValue(), buffer);
        }
    }

    protected final <K, V> Map<K, V> readMap(ByteBuf buffer, Function<ByteBuf, K> keyReader, Function<ByteBuf, V> valueReader) {
        int size = this.readVarInt(buffer);
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < size; ++i) {
            map.put(keyReader.apply(buffer), valueReader.apply(buffer));
        }
        return map;
    }

    protected final <E extends Enum<E>> void writeEnum(E value, ByteBuf buf) {
        this.writeVarInt(value.ordinal(), buf);
    }

    protected final <E extends Enum<E>> E readEnum(ByteBuf buf, Class<E> cls) {
        return (E)((Enum[])cls.getEnumConstants())[this.readVarInt(buf)];
    }
}

