/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public final class ChatMessagePacket
extends CarbonPacket {
    private UUID userId;
    private String channelPermission;
    private Key channelKey;
    private String username;
    private Component message;

    public UUID userId() {
        return this.userId;
    }

    public String channelPermission() {
        return this.channelPermission;
    }

    public Key channelKey() {
        return this.channelKey;
    }

    public String username() {
        return this.username;
    }

    public Component message() {
        return this.message;
    }

    public ChatMessagePacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public ChatMessagePacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    public ChatMessagePacket(@NotNull UUID serverId, UUID userId, Key channelKey, String username, Component message) {
        super(serverId);
        this.userId = userId;
        this.channelKey = channelKey;
        this.username = username;
        this.message = message;
    }

    @Override
    public void read(@NotNull ByteBuf buffer) {
        this.userId = this.readUUID(buffer);
        this.channelKey = this.readKey(buffer);
        this.username = this.readString(buffer);
        this.message = this.readComponent(buffer);
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        this.writeUUID(this.userId, buffer);
        this.writeKey(this.channelKey, buffer);
        this.writeString(this.username, buffer);
        this.writeComponent(this.message, buffer);
    }
}

