/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class DisbandPartyPacket
extends CarbonPacket {
    private @MonotonicNonNull UUID partyId;

    @AssistedInject
    public DisbandPartyPacket(@ServerId UUID serverId, @Assisted UUID partyId) {
        super(serverId);
        this.partyId = partyId;
    }

    public DisbandPartyPacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID partyId() {
        return this.partyId;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.partyId = this.readUUID(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.partyId, buffer);
    }

    public String toString() {
        return "DisbandPartyPacket{partyId=" + String.valueOf(this.partyId) + ", sender=" + String.valueOf(this.sender) + "}";
    }
}

