/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class InvalidatePartyInvitePacket
extends CarbonPacket {
    private @MonotonicNonNull UUID from;
    private @MonotonicNonNull UUID to;

    @AssistedInject
    public InvalidatePartyInvitePacket(@ServerId UUID serverId, @Assisted(value="from") UUID from, @Assisted(value="to") UUID to) {
        super(serverId);
        this.from = from;
        this.to = to;
    }

    public InvalidatePartyInvitePacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID from() {
        return this.from;
    }

    public UUID to() {
        return this.to;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.from = this.readUUID(buffer);
        this.to = this.readUUID(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.from, buffer);
        this.writeUUID(this.to, buffer);
    }
}

