/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class LocalPlayerChangePacket
extends CarbonPacket {
    private @MonotonicNonNull UUID playerId;
    private @MonotonicNonNull String playerName;
    private @MonotonicNonNull ChangeType changeType;

    @AssistedInject
    public LocalPlayerChangePacket(@ServerId UUID serverId, @Assisted UUID playerId, @Assisted @Nullable String playerName, @Assisted ChangeType changeType) {
        super(serverId);
        if (changeType == ChangeType.ADD && playerName == null) {
            throw new IllegalArgumentException("playerName cannot be null for ChangeType.ADD");
        }
        this.playerId = playerId;
        this.playerName = playerName;
        this.changeType = changeType;
    }

    public LocalPlayerChangePacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID playerId() {
        return this.playerId;
    }

    public String playerName() {
        return this.playerName;
    }

    public ChangeType changeType() {
        return this.changeType;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.playerId = this.readUUID(buffer);
        String type = this.readString(buffer);
        this.changeType = ChangeType.valueOf(type);
        if (this.changeType == ChangeType.ADD) {
            this.playerName = this.readString(buffer);
        }
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.playerId, buffer);
        this.writeString(this.changeType.name(), buffer);
        if (this.changeType == ChangeType.ADD) {
            this.writeString(this.playerName, buffer);
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE;

    }
}

