/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class LocalPlayersPacket
extends CarbonPacket {
    private @MonotonicNonNull Map<UUID, String> players;

    @AssistedInject
    public LocalPlayersPacket(@ServerId UUID serverId, @Assisted Map<UUID, String> players) {
        super(serverId);
        this.players = players;
    }

    public LocalPlayersPacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public Map<UUID, String> players() {
        return this.players;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.players = this.readMap(buffer, x$0 -> this.readUUID((ByteBuf)x$0), x$0 -> this.readString((ByteBuf)x$0));
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeMap(this.players, (x$0, x$1) -> this.writeUUID((UUID)x$0, (ByteBuf)x$1), (x$0, x$1) -> this.writeString((String)x$0, (ByteBuf)x$1), buffer);
    }
}

