/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;
import net.draycia.carbon.common.users.PartyImpl;

@DefaultQualifier(value=NonNull.class)
public final class PartyChangePacket
extends CarbonPacket {
    private @MonotonicNonNull UUID partyId;
    private @MonotonicNonNull Map<UUID, PartyImpl.ChangeType> changes;

    @AssistedInject
    public PartyChangePacket(@ServerId UUID serverId, @Assisted UUID partyId, @Assisted Map<UUID, PartyImpl.ChangeType> changes) {
        super(serverId);
        this.partyId = partyId;
        this.changes = changes;
    }

    public PartyChangePacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID partyId() {
        return this.partyId;
    }

    public Map<UUID, PartyImpl.ChangeType> changes() {
        return this.changes;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.partyId = this.readUUID(buffer);
        this.changes = this.readMap(buffer, x$0 -> this.readUUID((ByteBuf)x$0), buf -> this.readEnum((ByteBuf)buf, PartyImpl.ChangeType.class));
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.partyId, buffer);
        this.writeMap(this.changes, (x$0, x$1) -> this.writeUUID((UUID)x$0, (ByteBuf)x$1), this::writeEnum, buffer);
    }

    public String toString() {
        return "PartyChangePacket{partyId=" + String.valueOf(this.partyId) + ", changes=" + String.valueOf(this.changes) + ", sender=" + String.valueOf(this.sender) + "}";
    }
}

