/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class PartyInvitePacket
extends CarbonPacket {
    private @MonotonicNonNull UUID from;
    private @MonotonicNonNull UUID to;
    private @MonotonicNonNull UUID party;

    @AssistedInject
    public PartyInvitePacket(@ServerId UUID serverId, @Assisted(value="from") UUID from, @Assisted(value="to") UUID to, @Assisted(value="party") UUID party) {
        super(serverId);
        this.from = from;
        this.to = to;
        this.party = party;
    }

    public PartyInvitePacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID from() {
        return this.from;
    }

    public UUID to() {
        return this.to;
    }

    public UUID party() {
        return this.party;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.from = this.readUUID(buffer);
        this.to = this.readUUID(buffer);
        this.party = this.readUUID(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.from, buffer);
        this.writeUUID(this.to, buffer);
        this.writeUUID(this.party, buffer);
    }

    public String toString() {
        return "PartyInvitePacket{from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + ", party=" + String.valueOf(this.party) + ", sender=" + String.valueOf(this.sender) + "}";
    }
}

