/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;

@DefaultQualifier(value=NonNull.class)
public final class SaveCompletedPacket
extends CarbonPacket {
    private @MonotonicNonNull UUID player;

    @AssistedInject
    public SaveCompletedPacket(@ServerId UUID serverId, @Assisted UUID player) {
        super(serverId);
        this.player = player;
    }

    public SaveCompletedPacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID playerId() {
        return this.player;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.player = this.readUUID(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.player, buffer);
    }
}

