/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.messaging.packets;

import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.CarbonPacket;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public final class WhisperPacket
extends CarbonPacket {
    private @MonotonicNonNull UUID from;
    private @MonotonicNonNull UUID to;
    private @MonotonicNonNull Component message;

    @AssistedInject
    public WhisperPacket(@ServerId UUID serverId, @Assisted(value="from") UUID from, @Assisted(value="to") UUID to, @Assisted Component message) {
        super(serverId);
        this.from = from;
        this.to = to;
        this.message = message;
    }

    public WhisperPacket(UUID sender, ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public UUID from() {
        return this.from;
    }

    public UUID to() {
        return this.to;
    }

    public Component message() {
        return this.message;
    }

    @Override
    public void read(ByteBuf buffer) {
        this.from = this.readUUID(buffer);
        this.to = this.readUUID(buffer);
        this.message = this.readComponent(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.writeUUID(this.from, buffer);
        this.writeUUID(this.to, buffer);
        this.writeComponent(this.message, buffer);
    }

    public String toString() {
        return "WhisperPacket{from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + ", message=" + String.valueOf(this.message) + ", sender=" + String.valueOf(this.sender) + "}";
    }
}

