/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.serialisation.gson;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.kyori.adventure.key.Key;

@DefaultQualifier(value=NonNull.class)
public class ChatChannelSerializerGson
extends TypeAdapter<ChatChannel> {
    private final ChannelRegistry registry;

    @Inject
    public ChatChannelSerializerGson(ChannelRegistry registry) {
        this.registry = registry;
    }

    public void write(JsonWriter out, @Nullable ChatChannel value) throws IOException {
        if (value == null) {
            out.value((String)null);
        } else {
            out.value(value.key().asString());
        }
    }

    public @Nullable ChatChannel read(JsonReader in) throws IOException {
        @Nullable String channelName = in.nextString();
        if (channelName != null) {
            return this.registry.channel(Key.key((String)channelName));
        }
        return null;
    }
}

