/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.serialisation.gson;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.translation.Translator;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public class LocaleSerializerConfigurate
implements TypeSerializer<Locale> {
    private final Logger logger;

    @Inject
    public LocaleSerializerConfigurate(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Locale deserialize(Type type, ConfigurationNode node) {
        @Nullable String value = node.getString();
        if (value == null) {
            this.logger.warn("value null for locale! defaulting to en_US");
            return Locale.ENGLISH;
        }
        return Objects.requireNonNull(Translator.parseLocale((String)value), "value locale cannot be null!");
    }

    @Override
    public void serialize(Type type, @Nullable Locale obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
        } else {
            node.set(obj.toString());
        }
    }
}

