/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.github.benmanes.caffeine.cache.AsyncCache;
import carbonchat.libs.com.github.benmanes.caffeine.cache.Cache;
import carbonchat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.DisbandPartyPacket;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.messaging.packets.PartyChangePacket;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.PartyImpl;
import net.draycia.carbon.common.users.PlayerUtils;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.draycia.carbon.common.users.db.DatabaseUserManager;
import net.draycia.carbon.common.util.ConcurrentUtil;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public abstract class CachingUserManager
implements UserManagerInternal<CarbonPlayerCommon> {
    private static final int DISBAND_DELAY = 10;
    protected final Logger logger;
    protected final ProfileResolver profileResolver;
    private final ExecutorService executor;
    private final Injector injector;
    private final Provider<MessagingManager> messagingManager;
    private final PacketFactory packetFactory;
    private final CarbonServer server;
    private final ReentrantLock cacheLock;
    private final Map<UUID, CompletableFuture<CarbonPlayerCommon>> cache;
    private final AsyncCache<UUID, Party> partyCache;
    private final List<Runnable> queuedDisbands = new CopyOnWriteArrayList<Runnable>();
    private final Cache<UUID, Object> recentDisbands = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();

    protected CachingUserManager(Logger logger, ProfileResolver profileResolver, Injector injector, Provider<MessagingManager> messagingManager, PacketFactory packetFactory, CarbonServer server) {
        this.logger = logger;
        this.executor = Executors.newSingleThreadExecutor(ConcurrentUtil.carbonThreadFactory(logger, this.getClass().getSimpleName()));
        this.partyCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).buildAsync();
        this.profileResolver = profileResolver;
        this.injector = injector;
        this.messagingManager = messagingManager;
        this.packetFactory = packetFactory;
        this.server = server;
        this.cacheLock = new ReentrantLock();
        this.cache = new HashMap<UUID, CompletableFuture<CarbonPlayerCommon>>();
    }

    protected abstract CarbonPlayerCommon loadOrCreate(UUID var1);

    protected abstract void saveSync(CarbonPlayerCommon var1);

    protected abstract @Nullable PartyImpl loadParty(UUID var1);

    protected abstract void saveSync(PartyImpl var1, Map<UUID, PartyImpl.ChangeType> var2);

    protected abstract void disbandSync(UUID var1);

    private CompletableFuture<Void> save(CarbonPlayerCommon player) {
        return CompletableFuture.runAsync(() -> {
            this.saveSync(player);
            player.saved();
            ((MessagingManager)this.messagingManager.get()).queuePacketAndFlush(() -> this.packetFactory.saveCompletedPacket(player.uuid()));
        }, this.executor);
    }

    @Override
    public Party createParty(Component name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveCompleteMessageReceived(UUID playerId) {
        this.cacheLock.lock();
        try {
            this.cache.remove(playerId);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public CompletableFuture<Void> saveIfNeeded(CarbonPlayerCommon player) {
        if (!player.needsSave()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.save(player);
    }

    @Override
    public CompletableFuture<CarbonPlayerCommon> user(UUID uuid) {
        this.cacheLock.lock();
        try {
            CompletableFuture completableFuture = this.cache.computeIfAbsent(uuid, $ -> {
                CompletableFuture<CarbonPlayerCommon> future = CompletableFuture.supplyAsync(() -> {
                    CarbonPlayerCommon player = this.loadOrCreate(uuid);
                    this.injector.injectMembers((Object)player);
                    if (this instanceof DatabaseUserManager) {
                        player.registerPropertyUpdateListener(() -> this.save(player).exceptionally((Function)PlayerUtils.saveExceptionHandler(this.logger, player.username, uuid)));
                    }
                    return player;
                }, this.executor);
                this.attachPostLoad(uuid, future);
                return future;
            });
            return completableFuture;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.cacheLock.lock();
        for (Runnable task : this.queuedDisbands) {
            task.run();
        }
        try {
            Map collect = List.copyOf(this.cache.keySet()).stream().collect(Collectors.toMap(Function.identity(), this::loggedOut));
            for (Map.Entry entry : collect.entrySet()) {
                try {
                    entry.getValue().join();
                }
                catch (Exception ex) {
                    this.logger.warn("Exception saving data for player with uuid '{}'", entry.getKey(), (Object)ex);
                }
            }
            ConcurrentUtil.shutdownExecutor(this.executor, TimeUnit.MILLISECONDS, 500L);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> loggedOut(UUID uuid) {
        ((MessagingManager)this.messagingManager.get()).queuePacket(() -> this.packetFactory.removeLocalPlayerPacket(uuid));
        this.cacheLock.lock();
        try {
            CarbonPlayerCommon join;
            @Nullable CompletableFuture<CarbonPlayerCommon> remove = this.cache.remove(uuid);
            if (remove != null && remove.isDone() && (join = remove.join()) != null) {
                CompletableFuture<Void> completableFuture = this.saveIfNeeded(join);
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.cacheLock.lock();
        try {
            for (Map.Entry<UUID, CompletableFuture<CarbonPlayerCommon>> entry : Map.copyOf(this.cache).entrySet()) {
                @Nullable CarbonPlayerCommon getNow = entry.getValue().getNow(null);
                if (getNow == null || !getNow.transientLoadedNeedsUnload()) continue;
                this.cache.remove(entry.getKey());
                this.saveIfNeeded(getNow).exceptionally((Function)PlayerUtils.saveExceptionHandler(this.logger, getNow.username, getNow.uuid()));
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void attachPostLoad(UUID uuid, CompletableFuture<CarbonPlayerCommon> future) {
        future.whenComplete((result, thr) -> {
            if (result == null || thr != null) {
                this.cacheLock.lock();
                try {
                    this.cache.remove(uuid);
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
        });
    }

    @Override
    public CompletableFuture<@Nullable Party> party(UUID id) {
        if (this.recentDisbands.getIfPresent((Object)id) != null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.partyCache.get((Object)id, (uuid, cacheExecutor) -> CompletableFuture.supplyAsync(() -> {
            @Nullable PartyImpl party = this.loadParty((UUID)uuid);
            if (party != null) {
                this.injector.injectMembers((Object)party);
            }
            return party;
        }, this.executor));
    }

    @Override
    public CompletableFuture<Void> saveParty(PartyImpl info) {
        return CompletableFuture.runAsync(() -> {
            Map<UUID, PartyImpl.ChangeType> changes = info.pollChanges();
            if (changes.isEmpty()) {
                return;
            }
            this.saveSync(info, changes);
            ((MessagingManager)this.messagingManager.get()).queuePacketAndFlush(() -> this.packetFactory.partyChange(info.id(), changes));
        }, this.executor);
    }

    @Override
    public final void disbandParty(UUID id) {
        this.partyCache.synchronous().invalidate((Object)id);
        AtomicBoolean ran = new AtomicBoolean(false);
        AtomicReference<Runnable> taskRef = new AtomicReference<Runnable>();
        Runnable task = () -> {
            if (ran.compareAndSet(false, true)) {
                this.disbandSync(id);
                this.queuedDisbands.remove(taskRef.get());
            }
        };
        taskRef.set(task);
        this.queuedDisbands.add(task);
        this.recentDisbands.put((Object)id, new Object());
        CompletableFuture.delayedExecutor(10L, TimeUnit.SECONDS, this.executor).execute(task);
        ((MessagingManager)this.messagingManager.get()).queuePacketAndFlush(() -> this.packetFactory.disbandParty(id));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void partyChangeMessageReceived(PartyChangePacket pkt) {
        @Nullable CompletableFuture<@Nullable Party> future = this.partyIfMemberOnline(pkt.partyId());
        if (future == null) {
            return;
        }
        ((CompletableFuture)future.thenAccept(party -> {
            if (party == null) {
                return;
            }
            @Nullable @Nullable PartyImpl impl = (PartyImpl)party;
            pkt.changes().forEach((id, type) -> {
                switch (type) {
                    case ADD: {
                        impl.addMemberRaw((UUID)id);
                        break;
                    }
                    case REMOVE: {
                        impl.removeMemberRaw((UUID)id);
                    }
                }
            });
        })).whenComplete(($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception handling party change packet {}", (Object)pkt, thr);
            }
        });
    }

    private @Nullable CompletableFuture<@Nullable Party> partyIfMemberOnline(UUID partyId) {
        @Nullable CompletableFuture<@Nullable Party> future = this.partyCache.getIfPresent((Object)partyId);
        if (future == null) {
            for (CarbonPlayer carbonPlayer : this.server.players()) {
                if (!partyId.equals(((WrappedCarbonPlayer)carbonPlayer).partyId())) continue;
                future = this.party(partyId);
            }
        }
        return future;
    }

    @Override
    public void disbandPartyMessageReceived(DisbandPartyPacket pkt) {
        @Nullable CompletableFuture<@Nullable Party> future = this.partyIfMemberOnline(pkt.partyId());
        this.recentDisbands.put((Object)pkt.partyId(), new Object());
        if (future == null) {
            return;
        }
        ((CompletableFuture)future.thenAccept(party -> {
            if (party == null) {
                return;
            }
            ((PartyImpl)party).disbandRaw();
            this.partyCache.synchronous().invalidate((Object)pkt.partyId());
        })).whenComplete(($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception handling party disband packet {}", (Object)pkt, thr);
            }
        });
    }
}

