/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.api.util.InventorySlot;
import net.draycia.carbon.common.PlatformScheduler;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.users.PersistentUserProperty;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public class CarbonPlayerCommon
implements CarbonPlayer,
ForwardingAudience.Single {
    private static final long KEEP_TRANSIENT_LOADS_FOR = Duration.ofMinutes(2L).toMillis();
    @Inject
    private transient @MonotonicNonNull ChannelRegistry channelRegistry;
    @Inject
    private transient @MonotonicNonNull ProfileResolver profileResolver;
    @Inject
    private transient @MonotonicNonNull PlatformScheduler scheduler;
    @Inject
    private transient @MonotonicNonNull ConfigManager config;
    @Inject
    private transient @MonotonicNonNull CarbonMessageRenderer messageRenderer;
    @Inject
    private transient @MonotonicNonNull UserManagerInternal<?> users;
    private volatile transient long transientLoadedSince = -1L;
    protected final PersistentUserProperty<Boolean> muted;
    protected final PersistentUserProperty<Long> muteExpiration;
    protected final PersistentUserProperty<Boolean> deafened;
    protected final PersistentUserProperty<Key> selectedChannel;
    protected transient @MonotonicNonNull String username = null;
    protected @MonotonicNonNull UUID uuid;
    protected final PersistentUserProperty<Component> displayName;
    protected final PersistentUserProperty<UUID> lastWhisperTarget;
    protected final PersistentUserProperty<UUID> whisperReplyTarget;
    protected final PersistentUserProperty<Boolean> ignoringDirectMessages;
    protected final PersistentUserProperty<Boolean> spying;
    protected final PersistentUserProperty<Boolean> applyOptionalChatFilters;
    protected final PersistentUserProperty<Set<UUID>> ignoredPlayers;
    protected final PersistentUserProperty<Set<Key>> leftChannels;
    protected final PersistentUserProperty<UUID> party;

    public CarbonPlayerCommon(boolean muted, long muteExpiration, boolean deafened, @Nullable Key selectedChannel, @Nullable String username, UUID uuid, @Nullable Component displayName, @Nullable UUID lastWhisperTarget, @Nullable UUID whisperReplyTarget, boolean spying, boolean ignoreDirectMessages, @Nullable UUID party, boolean applyOptionalChatFilters) {
        this.muted = PersistentUserProperty.of(muted);
        this.muteExpiration = PersistentUserProperty.of(muteExpiration);
        this.deafened = PersistentUserProperty.of(deafened);
        this.selectedChannel = PersistentUserProperty.of(selectedChannel);
        this.username = username;
        this.uuid = uuid;
        this.displayName = PersistentUserProperty.of(displayName);
        this.lastWhisperTarget = PersistentUserProperty.of(lastWhisperTarget);
        this.whisperReplyTarget = PersistentUserProperty.of(whisperReplyTarget);
        this.spying = PersistentUserProperty.of(spying);
        this.ignoredPlayers = PersistentUserProperty.of(Collections.emptySet());
        this.leftChannels = PersistentUserProperty.of(Collections.emptySet());
        this.ignoringDirectMessages = PersistentUserProperty.of(ignoreDirectMessages);
        this.party = PersistentUserProperty.of(party);
        this.applyOptionalChatFilters = PersistentUserProperty.of(applyOptionalChatFilters);
    }

    public CarbonPlayerCommon(@Nullable String username, UUID uuid) {
        this.muted = PersistentUserProperty.of(false);
        this.muteExpiration = PersistentUserProperty.of(0L);
        this.deafened = PersistentUserProperty.of(false);
        this.selectedChannel = PersistentUserProperty.empty();
        this.displayName = PersistentUserProperty.empty();
        this.lastWhisperTarget = PersistentUserProperty.empty();
        this.whisperReplyTarget = PersistentUserProperty.empty();
        this.spying = PersistentUserProperty.of(false);
        this.ignoredPlayers = PersistentUserProperty.of(Collections.emptySet());
        this.leftChannels = PersistentUserProperty.of(Collections.emptySet());
        this.username = username;
        this.uuid = uuid;
        this.ignoringDirectMessages = PersistentUserProperty.of(false);
        this.party = PersistentUserProperty.empty();
        this.applyOptionalChatFilters = PersistentUserProperty.of(false);
    }

    public CarbonPlayerCommon() {
        this.muted = PersistentUserProperty.of(false);
        this.muteExpiration = PersistentUserProperty.of(0L);
        this.deafened = PersistentUserProperty.of(false);
        this.selectedChannel = PersistentUserProperty.empty();
        this.displayName = PersistentUserProperty.empty();
        this.lastWhisperTarget = PersistentUserProperty.empty();
        this.whisperReplyTarget = PersistentUserProperty.empty();
        this.spying = PersistentUserProperty.of(false);
        this.applyOptionalChatFilters = PersistentUserProperty.of(false);
        this.ignoredPlayers = PersistentUserProperty.of(Collections.emptySet());
        this.leftChannels = PersistentUserProperty.of(Collections.emptySet());
        this.ignoringDirectMessages = PersistentUserProperty.of(false);
        this.party = PersistentUserProperty.empty();
    }

    public boolean needsSave() {
        return this.properties().anyMatch(PersistentUserProperty::changed);
    }

    private Stream<PersistentUserProperty<?>> properties() {
        return Stream.of(this.muted, this.muteExpiration, this.deafened, this.selectedChannel, this.displayName, this.lastWhisperTarget, this.whisperReplyTarget, this.spying, this.applyOptionalChatFilters, this.ignoredPlayers, this.leftChannels, this.ignoringDirectMessages, this.party);
    }

    public void schedule(Runnable task) {
        this.scheduler.scheduleForPlayer(this, task);
    }

    public void registerPropertyUpdateListener(Runnable task) {
        this.properties().forEach(prop -> prop.registerUpdateListener(task));
    }

    public Audience audience() {
        return Audience.empty();
    }

    @Override
    public @Nullable Component createItemHoverComponent(InventorySlot slot) {
        return null;
    }

    @Override
    public @Nullable Component nickname() {
        if (!this.config.primaryConfig().nickname().useCarbonNicknames()) {
            return null;
        }
        return this.displayName.orNull();
    }

    public @Nullable Component nicknameRaw() {
        return this.displayName.orNull();
    }

    @Override
    public void nickname(@Nullable Component nickname) {
        this.displayName.set(nickname);
    }

    @Override
    public boolean hasPermission(String permission) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String primaryGroup() {
        return "default";
    }

    @Override
    public List<String> groups() {
        return List.of("default");
    }

    @Override
    public boolean muted() {
        if (this.muted.get().booleanValue()) {
            if (this.muteExpiration() > 0L) {
                return Instant.now().toEpochMilli() < this.muteExpiration();
            }
            return true;
        }
        return false;
    }

    @Override
    public void muted(boolean muted) {
        this.muted.set(muted);
    }

    @Override
    public long muteExpiration() {
        return this.muteExpiration.get();
    }

    @Override
    public void muteExpiration(long epochMillis) {
        this.muteExpiration.set(epochMillis);
    }

    @Override
    public Set<UUID> ignoring() {
        return this.ignoredPlayers.get();
    }

    @Override
    public boolean ignoring(UUID player) {
        return this.ignoredPlayers.get().contains(player);
    }

    @Override
    public boolean ignoring(CarbonPlayer player) {
        return this.ignoring(player.uuid());
    }

    public void ignoring(UUID player, boolean nowIgnoring, boolean internal) {
        HashSet<UUID> newIgnored = new HashSet<UUID>((Collection)this.ignoredPlayers.get());
        if (nowIgnoring) {
            newIgnored.add(player);
        } else {
            newIgnored.remove(player);
        }
        if (internal) {
            this.ignoredPlayers.internalSet(Collections.unmodifiableSet(newIgnored));
        } else {
            this.ignoredPlayers.set(Collections.unmodifiableSet(newIgnored));
        }
    }

    @Override
    public void ignoring(UUID player, boolean nowIgnoring) {
        this.ignoring(player, nowIgnoring, false);
    }

    @Override
    public void ignoring(CarbonPlayer player, boolean nowIgnoring) {
        this.ignoring(player.uuid(), nowIgnoring);
    }

    @Override
    public boolean deafened() {
        return this.deafened.get();
    }

    @Override
    public void deafened(boolean deafened) {
        this.deafened.set(deafened);
    }

    @Override
    public boolean spying() {
        return this.spying.get();
    }

    @Override
    public void spying(boolean spying) {
        this.spying.set(spying);
    }

    @Override
    public boolean ignoringDirectMessages() {
        return this.ignoringDirectMessages.get();
    }

    @Override
    public void ignoringDirectMessages(boolean ignoring) {
        this.ignoringDirectMessages.set(ignoring);
    }

    @Override
    public void sendMessageAsPlayer(String message) {
    }

    @Override
    public boolean online() {
        return false;
    }

    @Override
    public @Nullable UUID whisperReplyTarget() {
        return this.whisperReplyTarget.orNull();
    }

    @Override
    public void whisperReplyTarget(@Nullable UUID whisperReplyTarget) {
        this.whisperReplyTarget.set(whisperReplyTarget);
    }

    @Override
    public @Nullable UUID lastWhisperTarget() {
        return this.lastWhisperTarget.orNull();
    }

    @Override
    public void lastWhisperTarget(@Nullable UUID lastWhisperTarget) {
        this.lastWhisperTarget.set(lastWhisperTarget);
    }

    @Override
    public boolean vanished() {
        return false;
    }

    @Override
    public boolean awareOf(CarbonPlayer other) {
        return true;
    }

    @Override
    public List<Key> leftChannels() {
        return List.copyOf((Collection)this.leftChannels.get());
    }

    public void joinChannel(Key key, boolean internal) {
        HashSet newKeys = new HashSet(this.leftChannels.get());
        newKeys.remove(key);
        if (internal) {
            this.leftChannels.internalSet(Collections.unmodifiableSet(newKeys));
        } else {
            this.leftChannels.set(Collections.unmodifiableSet(newKeys));
        }
    }

    @Override
    public void joinChannel(ChatChannel channel) {
        this.joinChannel(channel.key(), false);
    }

    public void leaveChannel(ChatChannel channel, boolean internal) {
        HashSet<Key> newKeys = new HashSet<Key>((Collection)this.leftChannels.get());
        newKeys.add(channel.key());
        if (internal) {
            this.leftChannels.internalSet(Collections.unmodifiableSet(newKeys));
        } else {
            this.leftChannels.set(Collections.unmodifiableSet(newKeys));
        }
    }

    @Override
    public void leaveChannel(ChatChannel channel) {
        this.leaveChannel(channel, false);
    }

    public Identity identity() {
        return Identity.identity((UUID)this.uuid);
    }

    @Override
    public @Nullable Locale locale() {
        return Locale.getDefault();
    }

    @Override
    public @Nullable ChatChannel selectedChannel() {
        @Nullable Key selected = this.selectedChannelKey();
        return selected == null ? null : this.channelRegistry.channel(selected);
    }

    public ChannelRegistry channelRegistry() {
        return this.channelRegistry;
    }

    public @Nullable Key selectedChannelKey() {
        return this.selectedChannel.orNull();
    }

    @Override
    public void selectedChannel(@Nullable ChatChannel chatChannel) {
        if (chatChannel == null) {
            this.selectedChannel.set(null);
        } else {
            this.selectedChannel.set(chatChannel.key());
        }
    }

    @Override
    public CarbonPlayer.ChannelMessage channelForMessage(Component message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double distanceSquaredFrom(CarbonPlayer other) {
        return -1.0;
    }

    @Override
    public boolean sameWorldAs(CarbonPlayer other) {
        return false;
    }

    @Override
    public String username() {
        if (this.username == null) {
            this.username = Objects.requireNonNull(this.profileResolver.resolveName(this.uuid).join(), () -> "Failed to resolve username for player with UUID " + String.valueOf(this.uuid) + " (null result)");
        }
        return this.username;
    }

    @Override
    public Component displayName() {
        throw new UnsupportedOperationException();
    }

    public void username(String username) {
        this.username = username;
    }

    public void markTransientLoaded(boolean value) {
        this.transientLoadedSince = value ? System.currentTimeMillis() : -1L;
    }

    public boolean transientLoadedNeedsUnload() {
        return this.transientLoadedSince != -1L && System.currentTimeMillis() - this.transientLoadedSince > KEEP_TRANSIENT_LOADS_FOR;
    }

    @Override
    public boolean hasNickname() {
        if (!this.config.primaryConfig().nickname().useCarbonNicknames()) {
            return false;
        }
        return this.displayName.hasValue();
    }

    public ConfigManager configManager() {
        return this.config;
    }

    public CarbonMessageRenderer messageRenderer() {
        return this.messageRenderer;
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.uuid.equals(((CarbonPlayerCommon)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public void saved() {
        this.properties().forEach(PersistentUserProperty::saved);
    }

    public @Nullable UUID partyId() {
        return this.party.orNull();
    }

    @Override
    public CompletableFuture<@Nullable Party> party() {
        @Nullable UUID id = this.party.orNull();
        if (id == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.users.party(id);
    }

    public void party(@Nullable Party party) {
        this.party.set(party == null ? null : party.id());
    }

    @Override
    public boolean applyOptionalChatFilters() {
        return this.applyOptionalChatFilters.get();
    }

    @Override
    public void applyOptionalChatFilters(boolean applyOptionalChatFilters) {
        this.applyOptionalChatFilters.set(applyOptionalChatFilters);
    }
}

