/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.command.argument.PlayerSuggestions;
import net.draycia.carbon.common.messaging.packets.LocalPlayerChangePacket;
import net.draycia.carbon.common.messaging.packets.LocalPlayersPacket;
import net.draycia.carbon.common.users.ProfileCache;
import net.draycia.carbon.common.util.Exceptions;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.suggestion.Suggestion;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class NetworkUsers
implements PlayerSuggestions {
    private final CarbonServer server;
    private final Map<UUID, Map<UUID, String>> map = new ConcurrentHashMap<UUID, Map<UUID, String>>();
    private final UserManager<? extends CarbonPlayer> userManager;
    private final ProfileCache profileCache;

    @Inject
    private NetworkUsers(CarbonServer server, UserManager<?> userManager, ProfileCache profileCache) {
        this.server = server;
        this.userManager = userManager;
        this.profileCache = profileCache;
    }

    public void handlePacket(LocalPlayerChangePacket packet) {
        Map serverMap = this.map.computeIfAbsent(packet.getSender(), $ -> new ConcurrentHashMap());
        switch (packet.changeType()) {
            case ADD: {
                serverMap.put(packet.playerId(), packet.playerName());
                this.profileCache.cache(packet.playerId(), packet.playerName());
                break;
            }
            case REMOVE: {
                serverMap.remove(packet.playerId());
            }
        }
        this.map.values().removeIf(Map::isEmpty);
    }

    public void handlePacket(LocalPlayersPacket packet) {
        if (packet.players().isEmpty()) {
            this.map.remove(packet.getSender());
        } else {
            Map serverMap = this.map.computeIfAbsent(packet.getSender(), $ -> new ConcurrentHashMap());
            serverMap.clear();
            serverMap.putAll(packet.players());
            packet.players().forEach(this.profileCache::cache);
        }
    }

    public CompletableFuture<Iterable<Suggestion>> suggestionsFuture(CommandContext<Commander> ctx, CommandInput input) {
        Commander commander = (Commander)ctx.sender();
        List<? extends CarbonPlayer> local = this.server.players();
        if (!(commander instanceof PlayerCommander)) {
            return CompletableFuture.completedFuture(Stream.concat(local.stream().map(CarbonPlayer::username), this.map.values().stream().flatMap(m -> m.values().stream())).distinct().map(Suggestion::suggestion).toList());
        }
        PlayerCommander player = (PlayerCommander)commander;
        CarbonPlayer carbonPlayer = player.carbonPlayer();
        List<CompletableFuture> remotePlayerFutures = this.map.values().stream().flatMap(m -> m.keySet().stream()).map(this.userManager::user).toList();
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])remotePlayerFutures.toArray(CompletableFuture[]::new));
        try {
            combinedFuture.get(50L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception e) {
            throw Exceptions.rethrow(e);
        }
        Stream<CarbonPlayer> remote = remotePlayerFutures.stream().map(future -> future.getNow(null)).filter(Objects::nonNull);
        return CompletableFuture.completedFuture(Stream.concat(local.stream(), remote).filter(carbonPlayer::awareOf).map(CarbonPlayer::username).distinct().map(Suggestion::suggestion).toList());
    }

    public boolean online(CarbonPlayer player) {
        if (player.online()) {
            return true;
        }
        return this.map.values().stream().anyMatch(server -> server.containsKey(player.uuid()));
    }

    public boolean online(UUID uuid) {
        @Nullable CarbonPlayer player = this.server.players().stream().filter(it -> it.uuid().equals(uuid)).findFirst().orElse(null);
        return player != null || this.map.values().stream().anyMatch(server -> server.containsKey(uuid));
    }
}

