/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.PartyJoinEvent;
import net.draycia.carbon.api.event.events.PartyLeaveEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class PartyImpl
implements Party {
    private final Component name;
    private final UUID id;
    private final Set<UUID> members;
    private final transient @Nullable String serializedName;
    private volatile transient @MonotonicNonNull Map<UUID, ChangeType> changes;
    @Inject
    private transient @MonotonicNonNull UserManagerInternal<?> userManager;
    @Inject
    private transient @MonotonicNonNull CarbonServer server;
    @Inject
    private transient @MonotonicNonNull Logger logger;
    @Inject
    private transient @MonotonicNonNull CarbonEventHandler events;
    @Inject
    private transient @MonotonicNonNull CarbonMessages messages;
    private volatile transient boolean disbanded = false;

    private PartyImpl(Component name, UUID id) {
        this.serializedName = (String)GsonComponentSerializer.gson().serialize(name);
        if (this.serializedName.toCharArray().length > 8192) {
            throw new IllegalArgumentException("Serialized party name is too long: '%s', %s > 8192".formatted(name, this.serializedName.toCharArray().length));
        }
        this.name = name;
        this.id = id;
        this.members = ConcurrentHashMap.newKeySet();
        this.changes = new ConcurrentHashMap<UUID, ChangeType>();
    }

    public static PartyImpl create(Component name) {
        return PartyImpl.create(name, UUID.randomUUID());
    }

    public static PartyImpl create(Component name, UUID id) {
        return new PartyImpl(name, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<UUID, ChangeType> changes() {
        if (this.changes == null) {
            PartyImpl partyImpl = this;
            synchronized (partyImpl) {
                if (this.changes == null) {
                    this.changes = new ConcurrentHashMap<UUID, ChangeType>();
                }
            }
        }
        return this.changes;
    }

    @Override
    public void addMember(UUID id) {
        if (this.disbanded) {
            throw new IllegalStateException("This party was disbanded.");
        }
        this.changes().put(id, ChangeType.ADD);
        this.addMemberRaw(id);
        BiConsumer<Void, @Nullable Throwable> exceptionHandler = ($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception adding member {} to group {}", (Object)id, (Object)this.id(), thr);
            }
        };
        this.userManager.saveParty(this).whenComplete((BiConsumer)exceptionHandler);
        ((CompletableFuture)this.userManager.user(id).thenCompose(user -> {
            WrappedCarbonPlayer wrapped = (WrappedCarbonPlayer)user;
            @Nullable UUID oldPartyId = wrapped.partyId();
            wrapped.party(this);
            if (oldPartyId != null) {
                return this.userManager.party(oldPartyId).thenAccept(old -> {
                    if (old != null) {
                        old.removeMember(user.uuid());
                    }
                });
            }
            return CompletableFuture.completedFuture(null);
        })).whenComplete(exceptionHandler);
    }

    @Override
    public void removeMember(UUID id) {
        if (this.disbanded) {
            throw new IllegalStateException("This party was disbanded.");
        }
        this.changes().put(id, ChangeType.REMOVE);
        this.removeMemberRaw(id);
        BiConsumer<Void, @Nullable Throwable> exceptionHandler = ($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception removing member {} from group {}", (Object)id, (Object)this.id(), thr);
            }
        };
        this.userManager.saveParty(this).whenComplete((BiConsumer)exceptionHandler);
        ((CompletableFuture)this.userManager.user(id).thenAccept(user -> {
            WrappedCarbonPlayer wrapped = (WrappedCarbonPlayer)user;
            if (Objects.equals(wrapped.partyId(), this.id)) {
                wrapped.party(null);
            }
        })).whenComplete(exceptionHandler);
    }

    @Override
    public Set<UUID> members() {
        if (this.disbanded) {
            throw new IllegalStateException("This party was disbanded.");
        }
        return Set.copyOf(this.members);
    }

    @Override
    public void disband() {
        if (this.disbanded) {
            throw new IllegalStateException("This party is already disbanded.");
        }
        this.disbandRaw();
        this.userManager.disbandParty(this.id);
    }

    public void disbandRaw() {
        this.disbanded = true;
        this.server.players().stream().filter(p -> this.members.contains(p.uuid())).forEach(p -> ((WrappedCarbonPlayer)p).party(null));
        for (UUID member : this.members) {
            this.emitLeaveEvent(member);
        }
    }

    public Set<UUID> rawMembers() {
        return this.members;
    }

    public void addMemberRaw(final UUID id) {
        this.members.add(id);
        this.events.emit(new PartyJoinEvent(){

            @Override
            public UUID playerId() {
                return id;
            }

            @Override
            public Party party() {
                return PartyImpl.this;
            }
        });
        this.notifyJoin(id);
    }

    public void removeMemberRaw(UUID id) {
        this.members.remove(id);
        this.emitLeaveEvent(id);
        this.notifyLeave(id);
    }

    private void emitLeaveEvent(final UUID id) {
        this.events.emit(new PartyLeaveEvent(){

            @Override
            public UUID playerId() {
                return id;
            }

            @Override
            public Party party() {
                return PartyImpl.this;
            }
        });
    }

    public Map<UUID, ChangeType> pollChanges() {
        Map<UUID, ChangeType> ret = Map.copyOf(this.changes());
        ret.forEach((id, t) -> this.changes().remove(id));
        return ret;
    }

    @Override
    public Component name() {
        return this.name;
    }

    public String serializedName() {
        return Objects.requireNonNullElseGet(this.serializedName, () -> (String)GsonComponentSerializer.gson().serialize(this.name));
    }

    @Override
    public UUID id() {
        return this.id;
    }

    private void notifyJoin(UUID joined) {
        this.notifyMembersChanged(joined, (p, party, member) -> this.messages.playerJoinedParty(member, party.name(), p.displayName()));
    }

    private void notifyLeave(UUID left) {
        this.notifyMembersChanged(left, (p, party, member) -> this.messages.playerLeftParty(member, party.name(), p.displayName()));
    }

    private void notifyMembersChanged(UUID changed, ChangeNotifier notify) {
        Supplier changedPlayer = Suppliers.memoize(() -> this.userManager.user(changed));
        for (CarbonPlayer carbonPlayer : this.server.players()) {
            if (carbonPlayer.uuid().equals(changed) || !this.members.contains(carbonPlayer.uuid())) continue;
            ((CompletableFuture)((CompletableFuture)changedPlayer.get()).thenAccept(p -> notify.notify((CarbonPlayer)p, this, player))).whenComplete(($, thr) -> {
                if (thr != null) {
                    this.logger.warn("Exception notifying members of party change", thr);
                }
            });
        }
    }

    public String toString() {
        return "PartyImpl[name=" + String.valueOf(this.name) + ", id=" + String.valueOf(this.id) + ", members=" + String.valueOf(this.members) + ", changes=" + String.valueOf(this.changes) + "]";
    }

    public static enum ChangeType {
        ADD,
        REMOVE;

    }

    @FunctionalInterface
    private static interface ChangeNotifier {
        public void notify(CarbonPlayer var1, Party var2, CarbonPlayer var3);
    }
}

